var stretchDropdown = {

	//-----------------------------------------
	// 設定値
	//-----------------------------------------
	conf : {

		targetCls : 'stretchDropdown',             // 対象のクラス名
		targetId : 'stretchDropdown',              // 対象のID
		targetIdCnt : 0,                           // Id用カウント
		targetElm : '',                            // 対象要素格納用
		dropdownFlameId : 'stretchDropdownFlame',  // iframeのID
		dropdownId : 'stretchDropdownBlock',       // 擬似ドロップダウン(iframe内)のID
		dropdownCls : 'stretchDropdownBlock',      // 擬似ドロップダウン(iframe内)のクラス名
		jsFilePath : '/lmrss/js/',                 // JSファイルの配置パス
		cssFilePath : '/lmrss/css/'                // CSSファイルの配置パス

	},

	//-----------------------------------------
	// main処理
	//-----------------------------------------
	main : function() {

		// IE判定
		var isMSIE = /*@cc_on!@*/false;

		if ( isMSIE ) {
			var selects = stretchDropdown.getTargetElements('select', stretchDropdown.conf.targetCls);
			for (var i = 0; i < selects.length; i++) {
				selects[i].attachEvent('onmousedown', stretchDropdown.create);
			}
			document.attachEvent('onclick', stretchDropdown.remove);
		}

	},

	//-----------------------------------------
	// ドロップダウン
	//-----------------------------------------
	create : function(e) {

		// 擬似ドロップダウン要素を削除
		var iframe = document.getElementById(stretchDropdown.conf.dropdownFlameId);
		if ( iframe ) {
			document.body.removeChild(iframe);
			var select = stretchDropdown.conf.targetElm;
			select.disabled = false;
		}

		// イベントをキャンセル
		event.returnValue = false;
		event.cancelBubble = true;

		// チェック
		var check = document.getElementById(stretchDropdown.conf.dropdownFlameId);
		if ( check ) {
			document.body.removeChild(iframe);
			var select = stretchDropdown.conf.targetElm;
			select.disabled = false;
			return;
		}

		// イベントから対象要素を取得
		var select = window.event.srcElement;
		stretchDropdown.conf.targetElm = select;
		select.disabled = true;

		// 位置を取得
		var pos = stretchDropdown.getElementPosition(select);
		var height = select.offsetHeight;

		// iframeを生成
		iframe = document.createElement("iframe");
		iframe.id = stretchDropdown.conf.dropdownFlameId;
		iframe.setAttribute('frameBorder', '0');
		iframe.style.position = 'absolute';
		iframe.style.zIndex = '100';
		iframe.style.top = (pos.top + height + 1) + 'px';
		iframe.style.left = pos.left + 'px';
		iframe.style.borderTopWidth = '1px';
		iframe.style.borderTopStyle = 'solid';
		iframe.style.borderTopColor = '#999';
		iframe.style.borderBottomWidth = '1px';
		iframe.style.borderBottomStyle = 'solid';
		iframe.style.borderBottomColor = '#999';
		iframe.style.borderLeftWidth = '1px';
		iframe.style.borderLeftStyle = 'solid';
		iframe.style.borderLeftColor = '#999';
		iframe.style.margin = '0';
		iframe.style.padding = '0';
		iframe.style.textAlign = 'left';
		document.body.appendChild(iframe);

		// selectにIDを割り振る
		if (!select.id) {
			stretchDropdown.conf.targetIdCnt = stretchDropdown.conf.targetIdCnt + 1;
			select.id = stretchDropdown.conf.targetId + stretchDropdown.conf.targetIdCnt;
		}

		// HTML生成
		var html = '';
		html = html + '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" dir="ltr">'+ '\n';
		html = html + '<head>'+ '\n';
		html = html + '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />' + '\n';
		html = html + '<meta http-equiv="Content-Script-Type" content="text/javascript" />' + '\n';
		html = html + '<meta http-equiv="Content-Style-Type" content="text/css" />' + '\n';
		html = html + '<title>stretchDropdown</title>' + '\n';
		html = html + '<script type="text/javascript" src="' + stretchDropdown.conf.jsFilePath + 'stretchDropdown.js"></script>' + '\n';
		html = html + '<link rel="stylesheet" type="text/css" media="all" href="' + stretchDropdown.conf.cssFilePath + 'stretchDropdown.css" />' + '\n';
		html = html + '<style type="text/css">' + '\n';
		html = html + 'body{' + '\n';
		html = html + 'margin:0;' + '\n';
		html = html + 'padding:0;' + '\n';
		html = html + 'border:none;' + '\n';
		html = html + '}' + '\n';
		html = html + '</style>' + '\n';
		html = html + '</head>' + '\n';
		html = html + '<body>' + '\n';
		html = html + '<ul class="' + stretchDropdown.conf.dropdownCls + '" id="' + stretchDropdown.conf.dropdownId + '">' + '\n';
		// selectのItemをセット
		for (var i = 0; i < select.options.length; i++) {
			html = html + '<li><a href="javascript:stretchDropdown.setAndRemove(\'' + select.id + '\',\'' + iframe.id + '\',\'' + i + '\');">' + select.options[i].text + '</a></li>';
		}
		html = html + '</ul>' + '\n';
		html = html + '</body>' + '\n';
		html = html + '</html>' + '\n';

		// HTMLをiframeに反映
		var doc = document.frames[iframe.id].document;
		doc.open();
		doc.write(html);
		doc.close();

		// 表示の調整
		iframe.style.display = 'block';
		iframe.style.width = document.frames[iframe.id].document.body.scrollWidth;
		// スクロールバーと枠線の設定
		if ( select.options.length < 8 ) {
			iframe.setAttribute('scrolling', 'yes');
			iframe.style.height = document.frames[iframe.id].document.body.scrollHeight;
			iframe.style.borderRightWidth = '1px';
			iframe.style.borderRightStyle = 'solid';
			iframe.style.borderRightColor = '#999';
			window.setTimeout(stretchDropdown.adjustWidth,1);
		} else {
			iframe.setAttribute('scrolling', 'yes');
			window.setTimeout(stretchDropdown.adjustWidthScroll,1);
		}

		return false;

	},

	//-----------------------------------------
	// iframeの幅の調整
	//-----------------------------------------
	adjustWidth : function() {
		var iframe = document.getElementById(stretchDropdown.conf.dropdownFlameId);
		if ( iframe ) {
			iframe.style.width = document.frames[iframe.id].document.body.scrollWidth;
		}
	},
	adjustWidthScroll : function() {
		var iframe = document.getElementById(stretchDropdown.conf.dropdownFlameId);
		if ( iframe ) {
			iframe.style.width = document.frames[iframe.id].document.body.scrollWidth + 18;
		}
	},

	//-----------------------------------------
	// 値をセットして非表示
	//-----------------------------------------
	setAndRemove : function(id, id2, index) {

		// 対象要素を取得
		var select = parent.document.getElementById(id);
		if (select) {
			select.disabled = false;
			select.selectedIndex = index;
		}
		// focus 2009.16.22 add
        select.focus();
		// 擬似ドロップダウンを非表示
		var iframe = parent.document.getElementById(id2);
		if (iframe) {
			parent.document.body.removeChild(iframe);
		}

		// onchangeイベントを呼び出し 2009.05.17 add
		select.fireEvent('onchange');

	},

	//-----------------------------------------
	// 非表示
	//-----------------------------------------
	remove : function(e) {

		var selects = stretchDropdown.getTargetElements('select', stretchDropdown.conf.targetCls);
		var flg = false;
		for (var i = 0; i < selects.length; i++) {
			if ( window.event.srcElement == selects[i] ) {
				flg = true;
			}
		}
		if ( !flg ) {
			// 擬似ドロップダウン要素を削除
			var iframe = document.getElementById(stretchDropdown.conf.dropdownFlameId);
			if ( iframe ) {
				document.body.removeChild(iframe);
				var select = stretchDropdown.conf.targetElm;
				select.disabled = false;
			}
			return;
		}

	},

	//-----------------------------------------
	// 対象要素のポジション取得
	//-----------------------------------------
	getElementPosition : function(element) {

		var offsetTrail = (typeof element == 'string') ? doc.getElementById(element): element;
		var x = 0; var y = 0;

		while (offsetTrail) {
			x += offsetTrail.offsetLeft;
			y += offsetTrail.offsetTop;
			offsetTrail = offsetTrail.offsetParent;
		}

		if (navigator.userAgent.indexOf('Mac') != -1 && typeof doc.body.leftMargin != "undefined") {
			x += doc.body.leftMargin;
			y += doc.body.topMargin;
		}

		return ({ "left": x, "top": y });

	},

	//-----------------------------------------
	// ターゲットタグを取得する
	//-----------------------------------------
	getTargetElements : function(tag, cls) {

		var elements = new Array();
		var targetElements = document.getElementsByTagName(tag);

		for (var i = 0; i < targetElements.length; i++) {
			if (targetElements[i].className.match(cls)) {
				elements[elements.length] = targetElements[i];
			}
		}

		return elements;

	},

	//-----------------------------------------
	// Loadイベントに追加
	//-----------------------------------------
	addLoadEvent : function() {
		try {
			window.addEventListener('load', this.main, false);
		} catch (e) {
			window.attachEvent('onload', this.main);
		}
	}

}

stretchDropdown.addLoadEvent();

