<?php

class Lmr01050_model extends Model {

    function __construct()
    {
        parent::Model();
    }

    /*---------------------------------------------------------*
     * wordを分割して配列へ
     *
     *--------------------------------------------------------*/
     function sep_word ($ary)
     {
        $word_ary = explode("&", $ary['word']);
        foreach ($word_ary as $val){
            $ary1 = explode("=", $val);
            $ary[$ary1[0]] = $ary1[1];
        }
        return $ary;
     }

    /*---------------------------------------------------------*
     * パラメータの設定
     * c1:  送り先チェック
     * c2:  出庫元チェック
     * c3:  送り状番号チェック
     * c4:  代行店送り状Noチェック
     * c5:  送り状年月日
     * c5:  入力年月日
     * s1:  グループ
     * s2:  検索区分
     * s3:  送り先
     * s4:  出庫元SP
     * s5:  送り状番号
     * s6:  代行店送状No
     * s7:  送状年月日
     * s8:  送状年月日
     * s9:  入力年月日
     * s10: 入力年月日
     * s11: 状態
     *--------------------------------------------------------*/
     function set_param ($ary)
     {
        $ary['c1'] = (empty($ary['c1'])) ? $this->input->post("c1"): $ary['c1'];
        $ary['c2'] = (empty($ary['c2'])) ? $this->input->post("c2"): $ary['c2'];
        $ary['c3'] = (empty($ary['c3'])) ? $this->input->post("c3"): $ary['c3'];
        $ary['c4'] = (empty($ary['c4'])) ? $this->input->post("c4"): $ary['c4'];
        $ary['c5'] = (empty($ary['c5'])) ? $this->input->post("c5"): $ary['c5'];
        $ary['c6'] = (empty($ary['c6'])) ? $this->input->post("c6"): $ary['c6'];
        $ary['s1'] = (empty($ary['s1'])) ? $this->input->post("s1"): $ary['s1'];
        $ary['s2'] = (empty($ary['s2'])) ? $this->input->post("s2"): $ary['s2'];
        $ary['s3'] = (empty($ary['s3'])) ? $this->input->post("s3"): $ary['s3'];
        $ary['s4'] = (empty($ary['s4'])) ? $this->input->post("s4"): $ary['s4'];
        $ary['s5'] = (empty($ary['s5'])) ? $this->input->post("s5"): $ary['s5'];
        $ary['s6'] = (empty($ary['s6'])) ? $this->input->post("s6"): $ary['s6'];
        $ary['s7'] = (empty($ary['s7'])) ? $this->input->post("s7"): $ary['s7'];
        $ary['s8'] = (empty($ary['s8'])) ? $this->input->post("s8"): $ary['s8'];
        $ary['s9'] = (empty($ary['s9'])) ? $this->input->post("s9"): $ary['s9'];
        $ary['s10'] = (empty($ary['s10'])) ? $this->input->post("s10"): $ary['s10'];
        $ary['s11'] = (empty($ary['s11'])) ? $this->input->post("s11"): $ary['s11'];
        return $ary;
     }
    /*---------------------------------------------------------*
     * URL作成
     *
     *--------------------------------------------------------*/
     function set_url ($ary)
     {
         return  's1='. $ary['s1']
            . '&s2='. $ary['s2']
            . '&s3='. $ary['s3']
            . '&s4='. $ary['s4']
            . '&s5='. $ary['s5']
            . '&s6='. $ary['s6']
            . '&s7='. $ary['s7']
            . '&s8='. $ary['s8']
            . '&s9='. $ary['s9']
            . '&s10='. $ary['s10']
            . '&s11='. $ary['s11']
            . '&c1='. $ary['c1']
            . '&c2='. $ary['c2']
            . '&c3='. $ary['c3']
            . '&c4='. $ary['c4']
            . '&c5='. $ary['c5']
            . '&c6='. $ary['c6'];
     }
    /*---------------------------------------------------------*
     * validation
     *
     *--------------------------------------------------------*/
     function validation ($ary)
     {
        $err = 0;
        if (!$this->validation->required($ary['s1'])){
            $this->validation->custom_error('グループは必須です');
            $err = 1;
        }
        if (!$this->validation->required($ary['s2'])){
            $this->validation->custom_error('検索区分は必須です');
            $err = 1;
        }
        if ($ary['c1'] == 'y'){
            if (!$this->validation->required($ary['s3'])){
                $this->validation->custom_error('送り先を選択してください');
                $err = 1;
            }
        }
        if ($ary['c2'] == 'y'){
            if (!$this->validation->required($ary['s4'])){
                $this->validation->custom_error('出庫元SPを選択してください');
                $err = 1;
            }
        }
        if ($ary['c3'] == 'y'){
            if (!$this->validation->numeric($ary['s5'])){
                $this->validation->custom_error('送り状番号は数字しか入力できません');
                $err = 1;
            }
        }
        if ($ary['c4'] == 'y'){
            if (!$this->validation->numeric($ary['s6'])){
                $this->validation->custom_error('代行店送状No.は数字しか入力できません');
                $err = 1;
            }
        }


        if ($ary['c5'] == 'y'){
            if (!$this->validation->required($ary['s7']) && !$this->validation->required($ary['s8'])){
                $this->validation->custom_error('送り状年月日を指定してください');
                $err = 1;
            }
            else{
                if (!$this->validation->hiduke($ary['s7']) || !$this->validation->hiduke($ary['s8'])){
                    $this->validation->custom_error('送り状年月日の形式に誤りがあります');
                    $err = 1;
                }
                else{
                    if ($ary['s7'] > $ary['s8']){
                        $this->validation->custom_error('送り状年月日の範囲に誤りがあります');
                        $err = 1;
                    }
                }
            }
        }
        if ($ary['c6'] == 'y'){
            if (!$this->validation->required($ary['s9']) && !$this->validation->required($ary['s10'])){
                $this->validation->custom_error('入力年月日を指定してください');
                $err = 1;
            }
            else{
                if (!$this->validation->hiduke($ary['s9']) || !$this->validation->hiduke($ary['s10'])){
                    $this->validation->custom_error('入力年月日の形式に誤りがあります');
                    $err = 1;
                }
                else{
                    if ($ary['s9'] > $ary['s10']){
                        $this->validation->custom_error('入力年月日の範囲に誤りがあります');
                        $err = 1;
                    }
                }
            }

        }
        return $err;
     }
    /*---------------------------------------------------------*
     * SQL
     * @select
     *
     *--------------------------------------------------------*/
     function sql_select ()
     {
        $this->db->select('d0201.denno as denno');
        $this->db->select('d0201.daiko_id as daiko_id');
        $this->db->select('d0201.grp_id as grp_id');
        $this->db->select('d0201.daiko_denno as daiko_denno');
        $this->db->select('d0201.syuka_ymd as syuka_ymd');
        $this->db->select('d0201.nyuka_ymd as nyuka_ymd');
        $this->db->select('d0201.okuri_id as okuri_id');
        $this->db->select('d0201.syukosp_id as syukosp_id');
        $this->db->select('d0201.bin as bin');
        $this->db->select('d0201.syaban as syaban');
        $this->db->select('d0201.okuri_ymd as okuri_ymd');
        $this->db->select('d0201.okuri_time as okuri_time');
        $this->db->select('d0201.center_ymd as center_ymd');
        $this->db->select('d0201.center_time as center_time');
        $this->db->select('d0201.ins_ymd as ins_ymd');
        $this->db->select('d0201.ins_time as ins_time');
     }
    /*---------------------------------------------------------*
     * SQL
     * @from join
     *
     *--------------------------------------------------------*/
     function sql_from_join ()
     {
        $this->db->from('d0201');
     }
    /*---------------------------------------------------------*
     * SQL
     * @where
     *
     *--------------------------------------------------------*/
     function sql_where ($ary)
     {
        //代行店
        $this->db->where('d0201.daiko_id', $this->session->userdata("m0003_syozoku_id"));

        //グループ
        if (!empty($ary['s1'])){
            $this->db->where('d0201.grp_id', $ary['s1']);
        }

        //検索区分
        if (!empty($ary['s2'])){
            if ($ary['s2'] == 3){
                $this->db->where('d0201.okuri_ymd', '');
            }
            elseif($ary['s2'] == 4){
                $this->db->where('d0201.okuri_ymd<>', '');
            }
        }

        //送り先
        if ($ary['c1'] == 'y' && !empty($ary['s3'])){
            $this->db->where('d0201.okuri_id', $ary['s3']);
        }
        //出庫元SP
        if ($ary['c2'] == 'y' && !empty($ary['s4'])){
            $this->db->where('d0201.syukosp_id', $ary['s4']);
        }
        //送り状番号
        if ($ary['c3'] == 'y' && !empty($ary['s5'])){
            $this->db->where('d0201.denno', $ary['s5']);
        }
        //代行店送り状No
        if ($ary['c4'] == 'y' && !empty($ary['s6'])){
            $this->db->where('d0201.daiko_denno', $ary['s6']);
        }

        //送状年月日
        if ($ary['c5'] == 'y' && (!empty($ary['s7']) || !empty($ary['s8']))){
            if (!empty($ary['s7'])){
                $this->db->where('d0201.syuka_ymd>=', ymd_del_c($ary['s7']));
            }
            if (!empty($ary['s8'])){
                $this->db->where('d0201.syuka_ymd<=', ymd_del_c($ary['s8']));
            }
        }
        //入力年月日
        if ($ary['c6'] == 'y' &&  (!empty($ary['s9']) || !empty($ary['s10']))){
            if (!empty($ary['s9'])){
                $this->db->where('d0201.ins_ymd>=', ymd_del_c($ary['s9']));
            }
            if (!empty($ary['s10'])){
                $this->db->where('d0201.ins_ymd<=', ymd_del_c($ary['s10']));
            }
        }
        //状態
        if ($ary['s11'] == 1){
            $this->db->where('d0201.nyuka_ymd', '');
        }
        elseif ($ary['s11'] == 2){
            $this->db->where('d0201.nyuka_ymd<>', '');
        }

     }

    /*---------------------------------------------------------*
     * SQL
     * @組み立て
     *
     *--------------------------------------------------------*/
     function find ($ary, $per_page, $page_offset)
     {
        $this->sql_select();

        //cache start
        $this->db->start_cache();

        $this->sql_from_join();

        $this->sql_where($ary);

        //cache stop
        $this->db->stop_cache();

        $this->db->order_by('denno asc');

        if ($page_offset != null){
            $page_offset = (int)$page_offset;
        }
        $this->db->limit($per_page, $page_offset);

        $query = $this->db->get();

        //全件数 cache使用
        $total = $this->db->count_all_results();

        $this->db->flush_cache();

        return array($query, $total);
     }

     function set_pagenation ($url, $total, $per_page, $page_offset)
     {
        return array(
            "base_url" => $url. '/',
            "total_rows" => $total,
            "page_offset" => $page_offset,
            "per_page" => $per_page,
            "page_prev" => '',
            "page_next" => '',
            "full_tag_open" => '',
            "full_tag_close" => '',
            "first_link" => '<img src="'. base_url(). 'images/popup/control_first.gif" width="16" height="16" />',
            "first_tag_open" => '<li class="first">',
            "first_tag_close" => '</li>',
            "last_link" => '<img src="'. base_url(). 'images/popup/control_last.gif" width="16" height="16" />',
            "last_tag_open" => '<li class="last">',
            "last_tag_close" => '</li>',
            "next_link" => '<img src="'. base_url(). 'images/popup/control_next.gif" width="16" height="16" />',
            "next_tag_open" => '<li class="next">',
            "next_tag_close" => '</li>',
            "prev_link" => '<img src="'. base_url(). 'images/popup/control_back.gif" width="16" height="16" />',
            "prev_tag_open" => '<li class="prev">',
            "prev_tag_close" => '</li>',
            "cur_tag_open" => '<strong> ',
            "cur_tag_close" => '</strong>',
            "num_tag_open" => '<li>',
            "num_tag_close" => '</li>',
            "num_full_tag_open" => '<li class="numbers"><ol start="1">',
            "num_full_tag_close" => '</ol></li>',
            "a_tag_push" => ''
         );
     }
    /*---------------------------------------------------------*
     * PDF
     *
     *--------------------------------------------------------*/
     function pdf($list)
     {
        require(APPPATH.'fpdf/mbfpdf.php');
        define('FPDF_FONTPATH', 'fpdf/font/');
        $this->pdf = new MBFPDF('L', 'mm', 'A4');
        $this->pdf->SetMargins(17.0, 25.0, 10.0);
        $this->pdf->AddMBFont(GOTHIC ,'SJIS');
        $this->pdf->SetAutoPageBreak(false, 20.0);

        $this->pdf->AddPage();
        $this->pdf->SetFont(GOTHIC,'',5);

        $this->pdf->SetFillColor(200);
        $this->pdf->Cell(10, 5, u8_sj('送り状 No'), 1, 0, 'C', 1);
        $this->pdf->Cell(11, 5, u8_sj('出荷年月日'), 1, 0, 'C', 1);
        $this->pdf->Cell(11, 5, u8_sj('入荷完了日'), 1, 0, 'C', 1);
        $this->pdf->Cell(11, 5, u8_sj('送り状発行日'), 1, 0, 'C', 1);
        $this->pdf->Cell(32, 5, u8_sj('グループ名称'), 1, 0, 'C', 1);
        $this->pdf->Cell(32, 5, u8_sj('送り先名称'), 1, 0, 'C', 1);
        $this->pdf->Cell(32, 5, u8_sj('出庫元Sp名称'), 1, 0, 'C', 1);
        $this->pdf->Cell(32, 5, u8_sj('ユーザー名称'), 1, 0, 'C', 1);
        $this->pdf->Cell(40, 5, u8_sj('品目名称'), 1, 0, 'C', 1);
        $this->pdf->Cell(15, 5, u8_sj('今回出荷総数'), 1, 0, 'C', 1);
        $this->pdf->Cell(15, 5, u8_sj('出荷数'), 1, 0, 'C', 1);
        $this->pdf->Cell(15, 5, u8_sj('調整数'), 1, 1, 'C', 1);



        $i = 0;
        foreach ($list as $row){
            $d0203 = array();
            //d0203取得
            if (!$d0203 = $this->get_d0203 ($row['denno'])){
                continue;
            }
            foreach ($d0203 as $val){
                if ($val['syuka_su'] <= 0 && $val['cyosei_su'] <= 0){
                    continue;
                }
                $this->pdf->SetFillColor(245);
                $this->pdf->Cell(10, 5, u8_sj($row['denno']), 1, 0, 'C', $i);
                $this->pdf->Cell(11, 5, ymd($row['syuka_ymd']), 1, 0, 'C', $i);
                $this->pdf->Cell(11, 5, ymd($row['nyuka_ymd']), 1, 0, 'C', $i);
                $this->pdf->Cell(11, 5, ymd($row['okuri_ymd']), 1, 0, 'C', $i);
                $this->pdf->Cell(32, 5, u8_sj($row['grp_name']), 1, 0, 'C', $i);
                $this->pdf->Cell(32, 5, u8_sj($row['okuri_name']), 1, 0, 'C', $i);
                $this->pdf->Cell(32, 5, u8_sj($row['syukosp_name']), 1, 0, 'C', $i);
                $this->pdf->Cell(32, 5, u8_sj($this->common_db_model->find_column("m0006", array("id" => $val['user_id']), "mei")), 1, 0, 'C', $i);
                $this->pdf->Cell(40, 5, u8_sj($val['hinmoku1']), 1, 0, 'C', $i);
                $this->pdf->Cell(15, 5, u8_sj($val['syuka_su']), 1, 0, 'C', $i);
                $this->pdf->Cell(15, 5, u8_sj($val['syuka_su']), 1, 0, 'C', $i);
                $this->pdf->Cell(15, 5, u8_sj($val['cyosei_su']), 1, 1, 'C', $i);

                $i++;
                if ($i == 2 ){
                    $i = 0;
                }
            }

        }


        $this->pdf->Output();
     }

        function to_wareki($ymd = '')
        {
            if ($ymd == ""){
                $ymd = date("Ymd");
            }
            $y = substr($ymd, 0, 4);
            $m = substr($ymd, 4, 2);
            $d = substr($ymd, 6, 2);
            //年月日を文字列として結合
            $ymd = sprintf("%02d%02d%02d", $y, $m, $d);
            if ($ymd <= "19120729") {
                $gg = "明治";
                $yy = $y - 1867;
            } elseif ($ymd >= "19120730" && $ymd <= "19261224") {
                $gg = "大正";
                $yy = $y - 1911;
            } elseif ($ymd >= "19261225" && $ymd <= "19890107") {
                $gg = "昭和";
                $yy = $y - 1925;
            } elseif ($ymd >= "19890108" && $ymd <= "20190499") {
                $gg = "平成";
                $yy = $y - 1988;
            } elseif ($ymd >= "20190501") {
              $gg = "令和";
              $yy = $y - 2018;
            }
            $wareki = "{$gg} {$yy} 年 {$m} 月 {$d} 日";
            return $wareki;
        }


     function write_fnc($str, $x, $y, $height)
     {
        $this->pdf->SetXY($x,$y);
        $this->pdf->Write($height,u8_sj($str));
     }
     function add_page($d0201_data, $d0201_list, $m0005_ary = array(), $title = 1)
     {

        if ($title == 1){
            $title = '出荷案内書 （控え）';

            $this->pdf->SetTitle($title);
            $this->pdf->SetFont(GOTHIC,'',17);
            $this->write_fnc($title, 80, 10, 12);
        }
        elseif($title == 2){
            $title = '出荷案内書 （出荷先）';

            $this->pdf->SetTitle($title);
            $this->pdf->SetFont(GOTHIC,'',17);
            $this->write_fnc($title, 80, 10, 12);
        }
        elseif($title == 3){
            $title = '出荷案内書 （運送業者）';

            $this->pdf->SetTitle($title);
            $this->pdf->SetFont(GOTHIC,'',17);
            $this->write_fnc($title, 80, 10, 12);
        }
        elseif($title == 4){
            $title = '回収品受領書';

            $this->pdf->SetTitle($title);
            $this->pdf->SetFont(GOTHIC,'',17);
            $this->write_fnc($title, 80, 10, 12);
        }


        $this->pdf->SetXY(150, 10);
        $this->pdf->SetFont(GOTHIC,'',9);
        $this->pdf->Cell(35, 5, u8_sj('送り状 No. '. $d0201_data['denno']), 0, 0, 'L');
        $this->pdf->Cell(12, 5, u8_sj('('. $d0201_data['count_str_pdf']. ')'), 0, 1, 'R');
        $this->pdf->SetFont(GOTHIC,'',9);
        $this->pdf->SetXY(150, $this->pdf->GetY());
        $this->pdf->Cell(47, 5, u8_sj($this->to_wareki()), 0, 1, 'L');


        //送り先会社名
        $this->pdf->SetXY(17, 28);
        $this->pdf->SetFont(GOTHIC,'',13);
        $this->pdf->Cell(70, 5, u8_sj($d0201_data['okurisaki_mei1']), 0, 1, 'L');
        $this->pdf->SetFont(GOTHIC,'',12);
        $this->pdf->Cell(70, 5, u8_sj($d0201_data['okurisaki_mei2']), 'B', 0, 'L');
        $this->pdf->Cell(20, 5, u8_sj('御中'), 'B', 1, 'R');
        $this->pdf->SetFont(GOTHIC,'',10);
        $this->pdf->Cell(90, 5, u8_sj($d0201_data['okurisaki_code']), 0, 1, 'R');

        //送り先会社名
        $this->pdf->SetXY(17, 45);
        $this->pdf->SetFont(GOTHIC,'',8);
        $this->pdf->Cell(70, 5, u8_sj('下記の通り出荷いたしましたから'), 0, 1, 'L');
        $this->pdf->Cell(70, 5, u8_sj('ご査収ください'), 0, 0, 'L');


        //会社情報
        $this->pdf->SetXY(120, 25);
        $this->pdf->SetFont(GOTHIC,'',11);
        $this->pdf->Cell(75, 5, u8_sj($m0005_ary['mei1']), 0, 1, 'L');
        $this->pdf->SetFont(GOTHIC,'',10);
        $this->pdf->SetXY(120, $this->pdf->GetY());
        $this->pdf->Cell(75, 5, u8_sj($m0005_ary['mei2']), 0, 1, 'L');
        $this->pdf->SetFont(GOTHIC,'',9);
        $this->pdf->SetXY(120, $this->pdf->GetY());
        $this->pdf->Cell(77, 5, u8_sj('〒 '. $m0005_ary['post']), 0, 1, 'L');
        $this->pdf->SetXY(120, $this->pdf->GetY());
        $this->pdf->Cell(76, 5, u8_sj($m0005_ary['jyusyo1']), 0, 1, 'L');
        $this->pdf->SetXY(120, $this->pdf->GetY());
        $this->pdf->Cell(76, 5, u8_sj($m0005_ary['jyusyo2']), 0, 1, 'L');
        $this->pdf->SetFont(GOTHIC,'',9);
        $this->pdf->SetXY(120, $this->pdf->GetY());
        $this->pdf->Cell(77, 5, u8_sj('電話番号　'. $m0005_ary['tel']. '　　 ＦＡＸ '. $m0005_ary['fax']), 0, 0, 'L');


        //出荷年月日　代行店送り状No
        $this->pdf->SetFont(GOTHIC,'',10);
        $this->pdf->SetXY(17, $this->pdf->GetY() + 5);
        $this->pdf->Cell(90, 8, u8_sj('出荷年月日     '. $this->to_wareki($d0201_data['syuka_ymd'])), 1, 0, 'L');
        $this->pdf->Cell(90, 8, u8_sj('代行店送状No.     '. $d0201_data['daiko_denno']), 1, 1, 'L');
        $this->pdf->Cell(90, 8, u8_sj('便名           '. $d0201_data['bin']), 1, 0, 'L');
        $this->pdf->Cell(90, 8, u8_sj('車両番号          '. $d0201_data['syaban']), 1, 1, 'L');

        //品目　数量　備考
        $this->pdf->SetFont(GOTHIC,'',9);
        $this->pdf->SetXY(17, $this->pdf->GetY() + 2);
        $this->pdf->Cell(110, 8, u8_sj('品              目'), 'LRT', 0, 'C');
        $this->pdf->Cell(30, 8, u8_sj('数       量'), 1, 0, 'C');
        $this->pdf->Cell(40, 8, u8_sj('備       考'), 1, 1, 'C');


            for($c = 0;$c < 20;$c++){

                $mei = (isset($d0201_list[$c]['mei'])) ? $d0201_list[$c]['mei']: '';
                $kikaku = (isset($d0201_list[$c]['kikaku'])) ? $d0201_list[$c]['kikaku']: '';
                $syuka_su = (isset($d0201_list[$c]['syuka_su'])) ? nf($d0201_list[$c]['syuka_su']): '';
                $biko1 = (isset($d0201_list[$c]['biko'])) ? $d0201_list[$c]['biko']: '';
                $biko2 = (isset($d0201_list[$c]['biko'])) ? $d0201_list[$c]['biko']: '';
                $tani = (isset($d0201_list[$c]['tani'])) ? $d0201_list[$c]['tani']: '';

                $y = $this->pdf->GetY();
                $this->pdf->SetFont(GOTHIC,'',9);
                $this->pdf->Cell(110, 4, u8_sj($mei, 30), 'LRT', 1, 'L');
                $this->pdf->SetFont(GOTHIC,'',9);
                $this->pdf->Cell(110, 4, u8_sj($kikaku, 60), 'LR', 0, 'L');
                $this->pdf->SetFont(GOTHIC,'',9);
                $this->pdf->SetXY($this->pdf->GetX(), $y);
                $this->pdf->Cell(30, 8, u8_sj($syuka_su. ' '. $tani), 1, 0, 'R');
                $this->pdf->SetFont(GOTHIC,'',9);
                $this->pdf->Cell(40, 4, u8_sj($biko1, 13), 'R', 2, 'L');
                $this->pdf->SetXY($this->pdf->GetX(), $this->pdf->GetY());
                $this->pdf->Cell(40, 4, u8_sj_etc($biko2, 13, 12), 'RB', 1, 'L', 0);

            }


        //フッター　記事
        //$this->pdf->SetXY($this->pdf->GetX(), $this->pdf->GetY() + 3);
        $this->pdf->SetFont(GOTHIC,'',8);
        $this->pdf->Cell(180, 6, u8_sj('(記事)'), 'LTR', 1, 'L');
        $this->pdf->Cell(180, 6, u8_sj('　'), 'LR', 1, 'C');
        $this->pdf->Cell(180, 13, u8_sj('　'), 'LRB', 1, 'C');

     }
    /*---------------------------------------------------------*
     * PDF 送り状発行
     *
     *--------------------------------------------------------*/
     function okuri_hakkou_pdf($d0201_ary, $m0005_ary)
     {
        require(APPPATH.'fpdf/mbfpdf.php');
        define('FPDF_FONTPATH', 'fpdf/font/');
        $this->pdf = new MBFPDF('P', 'mm', 'A4');
        $this->pdf->SetMargins(17.0, 25.0, 10.0);
        $this->pdf->AddMBFont(GOTHIC ,'SJIS');

        //default
        $hakkou[] = 1;

        if ($this->input->post('sel2') == "y"){
            $hakkou[] = 2;
        }
        if ($this->input->post('sel3') == "y"){
            $hakkou[] = 3;
        }
        if ($this->input->post('sel4') == "y"){
            $hakkou[] = 4;
        }

        foreach($hakkou as $hval){

            foreach ($d0201_ary as $key => $val){

                $val['d0201_data']['count_str'] = $val['d0202_list_total'];
                foreach ($val['d0202_list'] as $val2){
                    $this->pdf->AddPage();
                    $val['d0201_data']['count_str_pdf'] = $val2['count']. '/'. $val['d0201_data']['count_str'];
                    $this->add_page($val['d0201_data'], $val2['list'], $m0005_ary, $hval);

                }

            }
        }

        /*
        $this->pdf->AddPage();
        $this->pdf->SetFont(GOTHIC,'',7);
        $this->pdf->Write(10,u8_sj('サンプル文字列2'));
        */
        $this->pdf->Output('okuri.pdf', 'I');
     }

     /*---------------------------------------------------------*
     * SQL
     * 品目の取得
     * d0201
     * 引数:denno
     *
     *--------------------------------------------------------*/
    function get_d0201 ($denno)
    {
        $ary = array();
        $this->db->where(array("denno" => $denno));
        $this->db->limit(1);
        $query = $this->db->get('d0201');
        if ( $query->num_rows() > 0 ){
            return $query->row_array();
        }
        else{
            return false;
        }
    }

     /*---------------------------------------------------------*
     * SQL
     * 品目の取得
     * d0202
     * 引数:seq
     *
     *--------------------------------------------------------*/
    function get_d0202 ($seq)
    {
        $ary = array();
        $this->db->where(array("seq" => $seq));
        $this->db->limit(1);
        $query = $this->db->get('d0202');
        if ( $query->num_rows() > 0 ){
            return $query->row_array();
        }
        else{
            return false;
        }
    }

     /*---------------------------------------------------------*
     * SQL
     * 品目の取得
     * d0202
     * 引数:seq
     *
     *--------------------------------------------------------*/
    function get_d0202_pdf_list ($denno)
    {
        $ary = array();
        $this->db->select('m0004.mei as mei, m0004.kikaku as kikaku');
        $this->db->select('d0202.biko as biko, m0004.tani as tani');
        $this->db->select('d0202.syuka_su as syuka_su');
        $this->db->from('d0202');
        $this->db->join('m0004', 'd0202.hin_id=m0004.id', 'inner');
        $this->db->where(array("d0202.denno" => $denno));
        $this->db->order_by('d0202.seq asc');
        $query = $this->db->get();
        if ($query->num_rows() > 0)
        {
            foreach ($query->result_array() as $row)
            {
                $ary[] = $row;
            }
            return $ary;
        }
        return false;
    }

     /*---------------------------------------------------------*
     * SQL
     * 取引先マスタ
     *
     *--------------------------------------------------------*/
    function get_m0005_pdf ($id = null)
    {
        if ($id != null){
            $this->db->where("id", $id);
        }
        else{
            $this->db->where(array("id" => $this->session->userdata('m0003_syozoku_id')));
        }
        $this->db->limit(1);

        $query = $this->db->get('m0005');
        if ( $query->num_rows() > 0 ){
            return $query->row_array();
        }
        else{
            return false;
        }
    }

     /*---------------------------------------------------------*
     * SQL
     * 品目の取得
     * d0203
     * 引数:denno
     *
     *--------------------------------------------------------*/
    function get_d0203 ($denno)
    {
        $ary = array();

        $this->db->select('d0202.seq as seq');
        $this->db->select('d0202.hin_id as hin_id');
        $this->db->select('m0004.mei as hinmoku1');
        $this->db->select('d0202.syuka_su as syuka_su');
        $this->db->select('d0202.zan_su as zan_su');
        $this->db->select('d0202.biko as biko');
        $this->db->select('d0203.syuka_id as syuka_id');
        $this->db->select('d0203.syuka_denno as syuka_denno');
        $this->db->select('d0203.syuka_seq as syuka_seq');
        $this->db->select('d0203.syuka_su as syuka_su');
        $this->db->select('d0203.cyosei_su as cyosei_su');
        $this->db->select('d0102.user_id as user_id');


        $this->db->from('d0203');
        $this->db->join('d0202', 'd0203.seq=d0202.seq', 'inner');
        $this->db->join('m0004', 'd0202.hin_id=m0004.id', 'inner');
        $this->db->join('d0102', 'd0203.syuka_seq=d0102.seq', 'inner');
        $this->db->where(array("d0203.denno" => $denno));
        $this->db->order_by('d0203.seq desc');
        $query = $this->db->get_where('d0203');
        if ($query->num_rows() > 0)
        {
            foreach ($query->result_array() as $row)
            {
                $ary[] = $row;
            }
            return $ary;
        }
        return false;
    }
    /*---------------------------------------------------------*
     * EXCEL
     *
     *--------------------------------------------------------*/
     function excel($list)
     {
        $csv_ary = array();
        $csv = '';
        //取得エクセルファイル名作成：日付_集荷選別データ一覧
        $csv_file_name = date("Y年m月d日"). "_送り状データ検索結果一覧". ".csv";
        $csv_file_name = csv_escape($csv_file_name);

        //セルの値を設定
        $csv_ary[] = csv_escape('送り状No');
        $csv_ary[] = csv_escape('代行店CD');
        $csv_ary[] = csv_escape('出荷年月日');
        $csv_ary[] = csv_escape('入荷完了日');
        $csv_ary[] = csv_escape('グループCD');
        $csv_ary[] = csv_escape('グループ名称');
        $csv_ary[] = csv_escape('送り先CD');
        $csv_ary[] = csv_escape('送り先名称');
        $csv_ary[] = csv_escape('出庫元SPCD');
        $csv_ary[] = csv_escape('出庫元SP名称');
        $csv_ary[] = csv_escape('扱い便');
        $csv_ary[] = csv_escape('代行店送状No.');
        $csv_ary[] = csv_escape('車番号');
        $csv_ary[] = csv_escape('送り状発行日');
        $csv_ary[] = csv_escape('送り状発行時刻');
        $csv_ary[] = csv_escape('日次締日付');
        $csv_ary[] = csv_escape('日次締時刻');
        $csv_ary[] = csv_escape('送り状SEQ');
        $csv_ary[] = csv_escape('品目CD');
        $csv_ary[] = csv_escape('品目名称');
        $csv_ary[] = csv_escape('今回出荷総数');
        $csv_ary[] = csv_escape('残数');
        $csv_ary[] = csv_escape('備考');
        $csv_ary[] = csv_escape('出荷消込ID');
        $csv_ary[] = csv_escape('集荷伝票No.');
        $csv_ary[] = csv_escape('集荷SEQ');
        $csv_ary[] = csv_escape('出荷数');
        $csv_ary[] = csv_escape('調整数');
        $csv_ary[] = csv_escape('ユーザーCD');
        $csv_ary[] = csv_escape('ユーザー名称');


        $ary[] = implode(",", $csv_ary);

        foreach ($list as $row){
            $d0203 = array();
            //d0203取得
            if (!$d0203 = $this->get_d0203 ($row['denno'])){
                continue;
            }
            foreach ($d0203 as $val){
                if ($val['syuka_su'] <= 0 && $val['cyosei_su'] <= 0){
                    continue;
                }
                $csv_ary = array();
                $csv_ary[] = csv_escape($row['denno']);
                //代行店CD
                $daiko = $this->find_one("m0005", array("id" => $row['daiko_id']), "cd");
                $csv_ary[] = csv_escape($daiko['cd']);
                $csv_ary[] = ymd($row['syuka_ymd']);
                $csv_ary[] = ymd($row['nyuka_ymd']);
                //グループCD
                $grp = $this->find_one("m0002", array("id" => $row['grp_id']), "cd");
                $csv_ary[] = csv_escape($grp['cd']);
                $csv_ary[] = csv_escape($row['grp_name']);
                //送り先CD
                $okuri = $this->find_one("m0005", array("id" => $row['okuri_id']), "cd");
                $csv_ary[] = csv_escape($okuri['cd']);
                $csv_ary[] = csv_escape($row['okuri_name']);
                //出庫CD
                $syuko = $this->find_one("m0005", array("id" => $row['syukosp_id']), "cd");
                $csv_ary[] = csv_escape($syuko['cd']);
                $csv_ary[] = csv_escape($row['syukosp_name']);
                $csv_ary[] = csv_escape($row['bin']);
                $csv_ary[] = csv_escape($row['daiko_denno']);
                $csv_ary[] = csv_escape($row['syaban']);
                $csv_ary[] = ymd($row['okuri_ymd']);
                $csv_ary[] = ymd($row['okuri_time']);
                $csv_ary[] = ymd($row['center_ymd']);
                $csv_ary[] = ymd($row['center_time']);

                $csv_ary[] = csv_escape($val['seq']);
                //品目CD
                $hinmoku = $this->find_one("m0004", array("id" => $val['hin_id']), "cd");
                $csv_ary[] = csv_escape($hinmoku['cd']);
                $csv_ary[] = csv_escape($val['hinmoku1']);
                $csv_ary[] = csv_escape($val['syuka_su']);
                $csv_ary[] = csv_escape($val['zan_su']);
                $csv_ary[] = csv_escape($val['biko']);
                $csv_ary[] = csv_escape($val['syuka_id']);
                $csv_ary[] = csv_escape($val['syuka_denno']);
                $csv_ary[] = csv_escape($val['syuka_seq']);
                $csv_ary[] = csv_escape($val['syuka_su']);
                $csv_ary[] = csv_escape($val['cyosei_su']);
                //ユーザーCD
                $user = $this->find_one("m0006", array("id" => $val['user_id']), "cd, mei");
                if (count($user) > 0){
                    $csv_ary[] = csv_escape($user['cd']);
                    $csv_ary[] = csv_escape($user['mei']);
                }
                else{
                    $csv_ary[] = "";
                    $csv_ary[] = "";
                }

                $ary[] = implode(",", $csv_ary);
            }

        }

        $csv = implode("\n", $ary);

        //出力
        header("Cache-Control: public");
        header("Pragma: public");
        header("Content-type: application/x-msexcel-csv");
        header("Content-Disposition: attachment; filename=".$csv_file_name);
        echo $csv;
     }
/*---------------------------------------------------------*
 * 1件取得
 *
 *--------------------------------------------------------*/
    function find_one( $table = '', $where = '' ,$select = ''){
        $ary = array();
        if ($table == '' || $where == ''){
            return $ary;
        }
        if ($select == null){
            $this->db->select('*');
        }
        else{
            $this->db->select($select);
        }
        $query = $this->db->get_where( $table, $where, 1 );
        if ( $query->num_rows() > 0 ){
            return $query->row_array();
        }
        else{
            return $ary;
        }
    }
    /*---------------------------------------------------------*
     * ストックSPパーツ取得
     * @HTML表示部
     *
     *--------------------------------------------------------*/
     function get_m0005($id)
     {
        //stockp
        $this->db->select('m0005.mei1 as mei1');
        if ($id == ""){
            return '';
        }
        else{
            $query = $this->db->get_where( "m0005", array("id" => $id), 1 );
            if ( $query->num_rows() > 0 ){
                $ary = $query->row_array();
                return $ary['mei1'];
            }
            else{
                return '';
            }
        }
     }
    /*---------------------------------------------------------*
     * ストックSPパーツ取得
     * @HTML表示部
     *
     *--------------------------------------------------------*/
     function get_m0005_ini($id)
     {
        //stockp
        $this->db->select('m0005.ini as ini');
        if ($id == ""){
            return '';
        }
        else{
            $query = $this->db->get_where( "m0005", array("id" => $id), 1 );
            if ( $query->num_rows() > 0 ){
                $ary = $query->row_array();
                return $ary['ini'];
            }
            else{
                return '';
            }
        }
     }
    /*---------------------------------------------------------*
     * グループパーツ取得
     * @HTML表示部
     *
     *--------------------------------------------------------*/
     function get_m0002($id)
     {
        if ($id == ""){
            return '';
        }
        else{
            $this->db->select('m0002.name1 as name1');
            $query = $this->db->get_where( "m0002", array("id" => $id), 1 );
            if ( $query->num_rows() > 0 ){
                $ary = $query->row_array();
                return  $ary['name1'];
            }
            else{
                return '';
            }
        }
     }

    /*-----------------------------------------------------/
     * grp_idでセレクトボックス作成
     * ajax 送り先
    /-----------------------------------------------------*/
    function get_grp_selectbox ($ary = array(), $selected = ''){
        $str = '<option>選択してください</option>';
        if (count($ary) <= 0){
            return $str;
        }
        else{
            foreach ($ary as $val){
                if ($selected == $val['id']){
                    $selected_str = ' selected="selected"';
                }
                else{
                    $selected_str = '';
                }
                $str .= '<option value="'. $val['id']. '"'. $selected_str. '>'. trim($val['ini']). '</option>'. "\n";
            }
            return $str;
        }
    }
}
?>