<?php

class Lmr02021_model extends Model {

    var $group = array();
    var $plant = array();
    var $denku = array();
    var $from  = array();
    var $to    = array();


    function __construct()
    {
        parent::Model();
    }

    /*---------------------------------------------------------*
     * wordを分割して配列へ
     *
     *--------------------------------------------------------*/
     function sep_word ($ary)
     {
        $word_ary = explode("&", $ary['word']);
        foreach ($word_ary as $val){
            $ary1 = explode("=", $val);
            if (count($ary1) > 0){
                if (isset($ary1[1])){
                    $ary[$ary1[0]] = $ary1[1];
                }
            }
        }
        return $ary;
     }

    /*---------------------------------------------------------*
     * パラメータの設定
     * c1:  From払出倉庫
     * c2:  To出荷先
     * c3:  発注No
     * c4:  伝票番号
     * c7:  出荷年月日
     * c8:  入力年月日
     * c8:  相手伝票No
     * s1:  グループ
     * s2:  プラント
     * s3:  検索区分
     * s4:  伝票区分
     * s5:  From払出倉庫
     * s6:  To出荷先
     * s7:  伝票番号
     * s8: 入荷年月日
     * s9: 入荷年月日
     * s10: 入力年月日
     * s11: 入力年月日
     * s12: 相手伝票
     *--------------------------------------------------------*/
     function set_param ($ary)
     {
        $ary['c1'] = (empty($ary['c1'])) ? $this->input->post("c1"): $ary['c1'];
        $ary['c2'] = (empty($ary['c2'])) ? $this->input->post("c2"): $ary['c2'];
        $ary['c3'] = (empty($ary['c3'])) ? $this->input->post("c3"): $ary['c3'];
        $ary['c4'] = (empty($ary['c4'])) ? $this->input->post("c4"): $ary['c4'];
        $ary['c5'] = (empty($ary['c5'])) ? $this->input->post("c5"): $ary['c5'];
        $ary['c6'] = (empty($ary['c6'])) ? $this->input->post("c6"): $ary['c6'];
        $ary['c7'] = (empty($ary['c7'])) ? $this->input->post("c7"): $ary['c7'];
        $ary['s1'] = (empty($ary['s1'])) ? $this->input->post("s1"): $ary['s1'];
        $ary['s2'] = (empty($ary['s2'])) ? $this->input->post("s2"): $ary['s2'];
        $ary['s3'] = (empty($ary['s3'])) ? $this->input->post("s3"): $ary['s3'];
        $ary['s4'] = (empty($ary['s4'])) ? $this->input->post("s4"): $ary['s4'];
        $ary['s5'] = (empty($ary['s5'])) ? $this->input->post("s5"): $ary['s5'];
        $ary['s6'] = (empty($ary['s6'])) ? $this->input->post("s6"): $ary['s6'];
        $ary['s7'] = (empty($ary['s7'])) ? $this->input->post("s7"): $ary['s7'];
        $ary['s8'] = (empty($ary['s8'])) ? $this->input->post("s8"): $ary['s8'];
        $ary['s9'] = (empty($ary['s9'])) ? $this->input->post("s9"): $ary['s9'];
        $ary['s10'] = (empty($ary['s10'])) ? $this->input->post("s10"): $ary['s10'];
        $ary['s11'] = (empty($ary['s11'])) ? $this->input->post("s11"): $ary['s11'];
        $ary['s12'] = (empty($ary['s12'])) ? $this->input->post("s12"): $ary['s12'];
        return $ary;
     }
    /*---------------------------------------------------------*
     * URL作成
     *
     *--------------------------------------------------------*/
     function set_url ($ary)
     {
         return  's1='. $ary['s1']
            . '&s2='. $ary['s2']
            . '&s3='. $ary['s3']
            . '&s4='. $ary['s4']
            . '&s5='. $ary['s5']
            . '&s6='. $ary['s6']
            . '&s7='. $ary['s7']
            . '&s8='. $ary['s8']
            . '&s9='. $ary['s9']
            . '&s10='. $ary['s10']
            . '&s11='. $ary['s11']
            . '&s12='. $ary['s12']
            . '&c1='. $ary['c1']
            . '&c2='. $ary['c2']
            . '&c3='. $ary['c3']
            . '&c4='. $ary['c4']
            . '&c5='. $ary['c5']
            . '&c6='. $ary['c6']
            . '&c7='. $ary['c7'];
     }

    /*---------------------------------------------------------*
     * set select box
     *
     *--------------------------------------------------------*/
     function set_drop ($ary)
     {
        $this->group = $this->lmr02021_model->get_group_html($ary['s1']);

        if (isset($ary['s1'])){
            $this->plant = $this->lmr02021_model->get_plant_html($ary['s1'], $ary['s2']);
        }

        $this->denku = $this->lmr02021_model->get_denku_html($ary['s4']);

        if (isset($ary['s2']) && isset($ary['s4'])){
            $this->from = $this->lmr02021_model->get_from_html($ary['s2'], $ary['s4'], $ary['s5']);
        }
        if (isset($ary['s2']) && isset($ary['s4'])){
            $this->to = $this->lmr02021_model->get_to_html($ary['s2'], $ary['s4'], $ary['s6']);
        }
     }

    /*---------------------------------------------------------*
     * validation
     *
     *--------------------------------------------------------*/
     function validation ($ary)
     {
        $err = 0;
        if (!$this->validation->required($ary['s1'])){
            $this->validation->custom_error('グループは必須です');
            $err = 1;
        }
        if (!$this->validation->required($ary['s2'])){
            $this->validation->custom_error('プラント分は必須です');
            $err = 1;
        }
        if (!$this->validation->required($ary['s3'])){
            $this->validation->custom_error('検索区分は必須です');
            $err = 1;
        }
        /*
        if (!$this->validation->required($ary['s4']) || !$this->validation->numeric($ary['s4'])){
            $this->validation->custom_error('伝票区分は必須です');
            $err = 1;
        }
        */

        if ($ary['c1'] == 'y'){
            if (!$this->validation->required($ary['s5'])){
                $this->validation->custom_error('From回収元を選択してください');
                $err = 1;
            }
        }
        if ($ary['c2'] == 'y'){
            if (!$this->validation->required($ary['s6'])){
                $this->validation->custom_error('To受入倉庫を選択してください');
                $err = 1;
            }
        }

        if ($ary['c3'] == 'y'){
            if (!$this->validation->required($ary['s7'])){
                $this->validation->custom_error('伝票番号を入力してください');
                $err = 1;
            }
        }

        if ($ary['c4'] == 'y'){
            if (!$this->validation->required($ary['s8']) && !$this->validation->required($ary['s9'])){
                $this->validation->custom_error('入荷年月日を指定してください');
                $err = 1;
            }
            else{
                if (!$this->validation->hiduke($ary['s8']) || !$this->validation->hiduke($ary['s9'])){
                    $this->validation->custom_error('入荷年月日の形式に誤りがあります');
                    $err = 1;
                }
                else{
                    if ($ary['s8'] > $ary['s9']){
                        $this->validation->custom_error('入荷年月日の範囲に誤りがあります');
                        $err = 1;
                    }
                }
            }
        }
        if ($ary['c5'] == 'y'){
            if (!$this->validation->required($ary['s10']) && !$this->validation->required($ary['s11'])){
                $this->validation->custom_error('入力年月日を指定してください');
                $err = 1;
            }
            else{
                if (!$this->validation->hiduke($ary['s10']) || !$this->validation->hiduke($ary['s11'])){
                    $this->validation->custom_error('入力年月日の形式に誤りがあります');
                    $err = 1;
                }
                else{
                    if ($ary['s10'] > $ary['s11']){
                        $this->validation->custom_error('入力年月日の範囲に誤りがあります');
                        $err = 1;
                    }
                }
            }

        }
        if ($ary['c6'] == 'y'){
            if (!$this->validation->required($ary['s12'])){
                $this->validation->custom_error('相手伝票Noを入力してください');
                $err = 1;
            }
        }
        return $err;
     }
    /*---------------------------------------------------------*
     * SQL
     * @select
     *
     *--------------------------------------------------------*/
     function sql_select ()
     {
        $this->db->select('d0301.denno as denno');
        $this->db->select('d0301.denku_id as denku_id');
        $this->db->select('d0301.grp_id as grp_id');
        $this->db->select('d0301.plant_id as plant_id');
        $this->db->select('d0301.nyuka_ymd as nyuka_ymd');
        $this->db->select('d0301.syaban as syaban');
        $this->db->select('d0301.bin as bin');
        $this->db->select('d0301.syukosp_id as syukosp_id');
        $this->db->select('d0301.okuri_id as okuri_id');
        $this->db->select('d0301.daiko_denno as daiko_denno');
        $this->db->select('d0301.ins_ymd as ins_ymd');
        $this->db->select('d0301.ins_time as ins_time');
     }
    /*---------------------------------------------------------*
     * SQL
     * @from join
     *
     *--------------------------------------------------------*/
     function sql_from_join ()
     {
        $this->db->from('d0301');
     }
    /*---------------------------------------------------------*
     * SQL
     * @where
     *
     *--------------------------------------------------------*/
     function sql_where ($ary)
     {

        $this->db->where('d0301.ins_syozoku', $this->session->userdata("m0003_syozoku_id"));
        $this->db->where('d0301.syori_kbn', "2");

        if (!empty($ary['s1'])){
            $this->db->where('d0301.grp_id', $ary['s1']);
        }
        if (!empty($ary['s2'])){
            $this->db->where('d0301.plant_id', $ary['s2']);
        }

        //検索区分
        if (!empty($ary['s3'])){
            if ($ary['s3'] == "3"){
                $this->db->where('d0301.okuri_ymd', '');
            }
            elseif($ary['s3'] == "4"){
                $this->db->where('d0301.okuri_ymd<>', '');
            }

        }
        if (!empty($ary['s4'])){
            $this->db->where('d0301.denku_id', $ary['s4']);
        }

        if ($ary['c1'] == 'y' && !empty($ary['s5'])){
            $this->db->where('d0301.syukosp_id', $ary['s5']);
        }

        if ($ary['c2'] == 'y' && !empty($ary['s6'])){
            $this->db->where('d0301.okuri_id', $ary['s6']);
        }


        if ($ary['c3'] == 'y' && !empty($ary['s7'])){
            $this->db->where('d0301.denno', $ary['s7']);
        }

        if ($ary['c4'] == 'y' && (!empty($ary['s8']) || !empty($ary['s9']))){
            if (!empty($ary['s8'])){
                $this->db->where('d0301.nyuka_ymd>=', ymd_del_c($ary['s8']));
            }
            if (!empty($ary['s9'])){
                $this->db->where('d0301.nyuka_ymd<=', ymd_del_c($ary['s9']));
            }
        }

        if ($ary['c5'] == 'y' &&  (!empty($ary['s10']) || !empty($ary['s11']))){
            if (!empty($ary['s10'])){
                $this->db->where('d0301.ins_ymd>=', ymd_del_c($ary['s10']));
            }
            if (!empty($ary['s11'])){
                $this->db->where('d0301.ins_ymd<=', ymd_del_c($ary['s11']));
            }
        }
        if ($ary['c6'] == 'y' && !empty($ary['s12'])){
            $this->db->where('d0301.daiko_denno', $ary['s12']);
        }

     }

    /*---------------------------------------------------------*
     * SQL
     * @組み立て
     *
     *--------------------------------------------------------*/
     function find ($ary, $per_page, $page_offset)
     {
        $this->sql_select();

        //cache start
        $this->db->start_cache();

        $this->sql_from_join();

        $this->sql_where($ary);

        //cache stop
        $this->db->stop_cache();

        $this->db->order_by('denno asc');

        if ($page_offset != null){
            $page_offset = (int)$page_offset;
        }
        $this->db->limit($per_page, $page_offset);

        $query = $this->db->get();

        //全件数 cache使用
        $total = $this->db->count_all_results();

        $this->db->flush_cache();

        return array($query, $total);
     }

     function set_pagenation ($url, $total, $per_page, $page_offset)
     {
        return array(
            "base_url" => $url. '/',
            "total_rows" => $total,
            "page_offset" => $page_offset,
            "per_page" => $per_page,
            "page_prev" => '',
            "page_next" => '',
            "full_tag_open" => '',
            "full_tag_close" => '',
            "first_link" => '<img src="'. base_url(). 'images/popup/control_first.gif" width="16" height="16" />',
            "first_tag_open" => '<li class="first">',
            "first_tag_close" => '</li>',
            "last_link" => '<img src="'. base_url(). 'images/popup/control_last.gif" width="16" height="16" />',
            "last_tag_open" => '<li class="last">',
            "last_tag_close" => '</li>',
            "next_link" => '<img src="'. base_url(). 'images/popup/control_next.gif" width="16" height="16" />',
            "next_tag_open" => '<li class="next">',
            "next_tag_close" => '</li>',
            "prev_link" => '<img src="'. base_url(). 'images/popup/control_back.gif" width="16" height="16" />',
            "prev_tag_open" => '<li class="prev">',
            "prev_tag_close" => '</li>',
            "cur_tag_open" => '<strong> ',
            "cur_tag_close" => '</strong>',
            "num_tag_open" => '<li>',
            "num_tag_close" => '</li>',
            "num_full_tag_open" => '<li class="numbers"><ol start="1">',
            "num_full_tag_close" => '</ol></li>',
            "a_tag_push" => ''
         );
     }
        function to_wareki($ymd = '')
        {
            if ($ymd == ""){
                $ymd = date("Ymd");
            }
            $y = substr($ymd, 0, 4);
            $m = substr($ymd, 4, 2);
            $d = substr($ymd, 6, 2);
            //年月日を文字列として結合
            $ymd = sprintf("%02d%02d%02d", $y, $m, $d);
            if ($ymd <= "19120729") {
                $gg = "明治";
                $yy = $y - 1867;
            } elseif ($ymd >= "19120730" && $ymd <= "19261224") {
                $gg = "大正";
                $yy = $y - 1911;
            } elseif ($ymd >= "19261225" && $ymd <= "19890107") {
                $gg = "昭和";
                $yy = $y - 1925;
            } elseif ($ymd >= "19890108" && $ymd <= "20190499") {
              $gg = "平成";
              $yy = $y - 1988;
            } elseif ($ymd >= "20190501") {
              $gg = "令和";
              $yy = $y - 2018;
            }
            $wareki = "{$gg} {$yy} 年 {$m} 月 {$d} 日";
            return $wareki;
        }


     function write_fnc($str, $x, $y, $height)
     {
        $this->pdf->SetXY($x,$y);
        $this->pdf->Write($height,u8_sj($str));
     }
     function add_page($d0301_data, $d0301_list, $m0005_ary = array(), $title = 1)
     {

        /*---------------------------------------------------------*
         * 伝票No
         *--------------------------------------------------------*/
        $this->pdf->SetXY(17, 10);
        $this->pdf->SetFont(GOTHIC,'',11);
        $this->pdf->Cell(180, 5, u8_sj('送状No.   '. $d0301_data['denno']. '   ('. $d0301_data['count_str_pdf']. ')'), 0, 1, 'R');

        /*---------------------------------------------------------*
         * 納品書タイトル
         *--------------------------------------------------------*/
        $this->pdf->SetXY(17, $this->pdf->GetY() + 6);
        $denku_name = $d0301_data['denku']['name1'];
        $title = '('. $denku_name. ') 回 収 伝 票';
        $this->pdf->SetTitle($title);
        $this->pdf->SetFont(GOTHIC,'',17);
        $this->pdf->Cell(180, 10, u8_sj($title), 0, 1, 'C');


        /*---------------------------------------------------------*
         * 伝票No
         *--------------------------------------------------------*/
        $this->pdf->SetXY(17, $this->pdf->GetY() + 6);
        $this->pdf->SetFont(GOTHIC,'',11);
        $this->pdf->Cell(180, 5, u8_sj('入荷日   '. $this->to_wareki($d0301_data['nyuka_ymd'])), 0, 1, 'R');//2010.03.05修正

        $this->pdf->SetFont(GOTHIC,'',9);
        $this->pdf->Cell(22, 8, u8_sj(' グ ル ー プ '), 1, 0, 'C');
        $this->pdf->Cell(67, 8, u8_sj($d0301_data['grp']['name1']. $d0301_data['grp']['name2']), 1, 0, 'L');
        $this->pdf->Cell(2, 8, u8_sj(''), 0, 0, 'L');
        $this->pdf->Cell(22, 8, u8_sj(' プ ラ ン ト '), 1, 0, 'C');
        $this->pdf->Cell(67, 8, u8_sj($d0301_data['plant']['name1']. $d0301_data['plant']['name2']), 1, 1, 'L');

        $from_mei = (isset($d0301_data['from']['mei1'])) ? $d0301_data['from']['mei1'].$d0301_data['from']['mei2']: '';
        $to_mei = (isset($d0301_data['to']['mei1'])) ? $d0301_data['to']['mei1'].$d0301_data['to']['mei2']: '';

        $this->pdf->Cell(22, 8, u8_sj('From 回収元'), 1, 0, 'C');
        $this->pdf->Cell(67, 8, u8_sj($from_mei), 1, 0, 'L');
        $this->pdf->Cell(2, 8, u8_sj(''), 0, 0, 'L');
        $this->pdf->Cell(22, 8, u8_sj('To 受入倉庫'), 1, 0, 'C');
        $this->pdf->Cell(67, 8, u8_sj($to_mei), 1, 1, 'L');

        $this->pdf->Cell(22, 8, u8_sj(''), 1, 0, 'C');
        $this->pdf->Cell(67, 8, u8_sj(''), 1, 0, 'L');
        $this->pdf->Cell(2, 8, u8_sj(''), 0, 0, 'L');
        $this->pdf->Cell(22, 8, u8_sj(''), 1, 0, 'C');
        $this->pdf->Cell(67, 8, u8_sj(''), 1, 1, 'L');

        $this->pdf->Cell(22, 8, u8_sj('相手伝票No.'), 1, 0, 'C');
        $this->pdf->Cell(67, 8, u8_sj($d0301_data['daiko_denno']), 1, 0, 'L');
        $this->pdf->Cell(2, 8, u8_sj(''), 0, 0, 'L');
        $this->pdf->Cell(22, 8, u8_sj(''), 1, 0, 'C');
        $this->pdf->Cell(67, 8, u8_sj(''), 1, 1, 'L');

        $this->pdf->Cell(22, 8, u8_sj(' 扱 い 便 '), 1, 0, 'C');
        $this->pdf->Cell(67, 8, u8_sj($d0301_data['bin']), 1, 0, 'L');
        $this->pdf->Cell(2, 8, u8_sj(''), 0, 0, 'L');
        $this->pdf->Cell(22, 8, u8_sj(' 車 両 番 号 '), 1, 0, 'C');
        $this->pdf->Cell(67, 8, u8_sj($d0301_data['syaban']), 1, 1, 'L');

        /*---------------------------------------------------------*
         * 品目コード　品目　出荷数　備考
         *--------------------------------------------------------*/
        $this->pdf->SetFont(GOTHIC,'',8);
        $this->pdf->SetXY(17, $this->pdf->GetY() + 2);
        $this->pdf->Cell(20, 8, u8_sj('品目コード'), 'LRT', 0, 'C');
        $this->pdf->Cell(70, 8, u8_sj('  品                 目  '), 1, 0, 'C');
        $this->pdf->Cell(27, 8, u8_sj('   入  荷  数   '), 1, 0, 'C');
        $this->pdf->Cell(63, 8, u8_sj('  備                 考  '), 1, 1, 'C');


            for($c = 0;$c < 20;$c++){
                $cd = (isset($d0301_list[$c]['cd'])) ? $d0301_list[$c]['cd']: '';
                $mei = (isset($d0301_list[$c]['mei'])) ? $d0301_list[$c]['mei']: '';
                $kikaku = (isset($d0301_list[$c]['kikaku'])) ? $d0301_list[$c]['kikaku']: '';
                $nyuka_su = (isset($d0301_list[$c]['nyuka_su'])) ? nf($d0301_list[$c]['nyuka_su']): '';

                $biko = (isset($d0301_list[$c]['biko'])) ? $d0301_list[$c]['biko']: '';
                $biko = str_replace("\r\n","\n",$biko);
                $biko = str_replace("\r","\n",$biko);
                $biko = str_replace("\n","",$biko);
                $biko1 = mb_substr($biko, 0, 20, 'UTF-8');
                $biko2 = mb_substr($biko, 20, 20, 'UTF-8');

                $tani = (isset($d0301_list[$c]['tani'])) ? $d0301_list[$c]['tani']: '';
                /*---------------------------------------------------------*
                 * 品目コード　品目　出荷数　備考　中身
                 *--------------------------------------------------------*/
                $y = $this->pdf->GetY();

                $this->pdf->SetXY(17, $y);
                $this->pdf->SetFont(GOTHIC,'',8);
                $this->pdf->Cell(20, 8, u8_sj($cd), 1, 0, 'L');
                $this->pdf->SetXY(37, $y);
                $this->pdf->SetFont(GOTHIC,'',8);
                $this->pdf->Cell(70, 5, u8_sj($mei), 'LRT', 2, 'L');
                $this->pdf->SetFont(GOTHIC,'',8);
                $this->pdf->Cell(70, 3, u8_sj($kikaku), 'LRB', 0, 'L');
                $this->pdf->SetFont(GOTHIC,'',8);

                $this->pdf->SetXY($this->pdf->GetX(), $y);
                $this->pdf->SetFont(GOTHIC,'',8);
                $this->pdf->Cell(27, 8, u8_sj($nyuka_su. ' '. $tani), 1, 0, 'R');


                $this->pdf->SetFont(GOTHIC,'',8);
                $this->pdf->Cell(63, 4, u8_sj($biko1), 'R', 2, 'L');
                $this->pdf->Cell(63, 4, u8_sj($biko2), 'BR', 1, 'L');
            }

        $y = $this->pdf->GetY() + 2;


        /*---------------------------------------------------------*
         * フッター　記事
         *--------------------------------------------------------*/
        $this->pdf->SetFont(GOTHIC,'',5);
        $this->pdf->SetXY(17, $y);
        $this->pdf->Cell(180, 5, u8_sj('(記事)'), 'RLT', 2, 'L');
        $this->pdf->Cell(180, 20, '', 'RLB', 0, 'L');
     }
    /*---------------------------------------------------------*
     * PDF 送り状発行
     *
     *--------------------------------------------------------*/
     function okuri_hakkou_pdf($d0301_ary, $m0005_ary)
     {
        require(APPPATH.'fpdf/mbfpdf.php');
        define('FPDF_FONTPATH', 'fpdf/font/');
        $this->pdf = new MBFPDF('P', 'mm', 'A4');
        $this->pdf->SetMargins(17.0, 25.0, 10.0);
        $this->pdf->AddMBFont(GOTHIC ,'SJIS');
        $this->pdf->SetAutoPageBreak(false, 20.0);

        //default
        $hakkou[] = 1;

/*
 * 複数選択用
        if ($this->input->post('sel2') == "y"){
            $hakkou[] = 2;
        }
        if ($this->input->post('sel3') == "y"){
            $hakkou[] = 3;
        }
        if ($this->input->post('sel4') == "y"){
            $hakkou[] = 4;
        }
*/
        foreach($hakkou as $hval){

            foreach ($d0301_ary as $key => $val){

                $val['d0301_data']['count_str'] = $val['d0302_list_total'];
                foreach ($val['d0302_list'] as $val2){

                    $this->pdf->AddPage();
                    $val['d0301_data']['count_str_pdf'] = $val2['count']. '/'. $val['d0301_data']['count_str'];
                    $this->add_page($val['d0301_data'], $val2['list'], $m0005_ary, $hval);

                }

            }
        }

        /*
        $this->pdf->AddPage();
        $this->pdf->SetFont(GOTHIC,'',7);
        $this->pdf->Write(10,u8_sj('サンプル文字列2'));
        */
        $this->pdf->Output('kaisyu.pdf', 'I');
     }

     /*---------------------------------------------------------*
     * SQL
     * 品目の取得
     * d0201
     * 引数:denno
     *
     *--------------------------------------------------------*/
    function get_d0201 ($denno)
    {
        $ary = array();
        $this->db->where(array("denno" => $denno));
        $this->db->limit(1);
        $query = $this->db->get('d0201');
        if ( $query->num_rows() > 0 ){
            return $query->row_array();
        }
        else{
            return false;
        }
    }

     /*---------------------------------------------------------*
     * SQL
     * 品目の取得
     * d0202
     * 引数:seq
     *
     *--------------------------------------------------------*/
    function get_d0202 ($seq)
    {
        $ary = array();
        $this->db->where(array("seq" => $seq));
        $this->db->limit(1);
        $query = $this->db->get('d0202');
        if ( $query->num_rows() > 0 ){
            return $query->row_array();
        }
        else{
            return false;
        }
    }

     /*---------------------------------------------------------*
     * SQL
     * 品目の取得
     * d0202
     * 引数:seq
     *
     *--------------------------------------------------------*/
    function get_d0302_pdf_list ($denno)
    {
        $ary = array();
        $this->db->select('m0004.mei as mei, m0004.kikaku as kikaku');
        $this->db->select('d0302.biko as biko, m0004.tani as tani');
        $this->db->select('m0004.cd as cd');
        $this->db->select('d0302.nyuka_su as nyuka_su');
        $this->db->from('d0302');
        $this->db->join('m0004', 'd0302.hin_id=m0004.id', 'inner');
        $this->db->where(array("d0302.denno" => $denno));
        $query = $this->db->get();
        if ($query->num_rows() > 0)
        {
            foreach ($query->result_array() as $row)
            {
                $ary[] = $row;
            }
            return $ary;
        }
        return false;
    }

     /*---------------------------------------------------------*
     * SQL
     * 取引先マスタ
     *
     *--------------------------------------------------------*/
    function get_m0005_pdf ()
    {
        $ary = array();
        $this->db->where(array("id" => $this->session->userdata('m0003_syozoku_id')));
        $this->db->limit(1);
        $query = $this->db->get('m0005');
        if ( $query->num_rows() > 0 ){
            return $query->row_array();
        }
        else{
            return false;
        }
    }

     /*---------------------------------------------------------*
     * SQL
     * 品目の取得
     * d0203
     * 引数:denno
     *
     *--------------------------------------------------------*/
    function get_d0203 ($denno)
    {
        $ary = array();

        $this->db->select('d0202.seq as seq');
        $this->db->select('d0202.hin_id as hin_id');
        $this->db->select('m0004.mei as hinmoku1');
        $this->db->select('d0202.syuka_su as syuka_su');
        $this->db->select('d0202.zan_su as zan_su');
        $this->db->select('d0202.biko as biko');
        $this->db->select('d0203.syuka_id as syuka_id');
        $this->db->select('d0203.syuka_denno as syuka_denno');
        $this->db->select('d0203.syuka_seq as syuka_seq');
        $this->db->select('d0203.syuka_su as syuka_su');
        $this->db->select('d0203.cyosei_su as cyosei_su');
        $this->db->select('d0102.user_id as user_id');


        $this->db->from('d0203');
        $this->db->join('d0202', 'd0203.seq=d0202.seq', 'inner');
        $this->db->join('m0004', 'd0202.hin_id=m0004.id', 'inner');
        $this->db->join('d0102', 'd0203.syuka_seq=d0102.seq', 'inner');
        $this->db->where(array("d0203.denno" => $denno));
        $this->db->order_by('d0203.seq desc');
        $query = $this->db->get_where('d0203');
        if ($query->num_rows() > 0)
        {
            foreach ($query->result_array() as $row)
            {
                $ary[] = $row;
            }
            return $ary;
        }
        return false;
    }
    /*---------------------------------------------------------*
     * EXCEL
     *
     *--------------------------------------------------------*/
     function excel($list)
     {

        $csv_ary = array();
        $csv = '';
        //取得エクセルファイル名作成：日付_
        $csv_file_name = date("Y年m月d日"). '回収データ'. ".csv";
        $csv_file_name = csv_escape($csv_file_name);

        //セルの値を設定
        $csv_ary[] = csv_escape('処理区分名');
        $csv_ary[] = csv_escape('伝票区分名');
        $csv_ary[] = csv_escape('送り状No');
        $csv_ary[] = csv_escape('グループ名');
        $csv_ary[] = csv_escape('プラント名');
        $csv_ary[] = csv_escape('送り先CD');
        $csv_ary[] = csv_escape('送り先名');
        $csv_ary[] = csv_escape('出庫先SPCD');
        $csv_ary[] = csv_escape('出庫先SP名');
        $csv_ary[] = csv_escape('扱い便');
        $csv_ary[] = csv_escape('代行店送り状No.');
        $csv_ary[] = csv_escape('車番号');
        $csv_ary[] = csv_escape('入荷SEQ');
        $csv_ary[] = csv_escape('品目CD');
        $csv_ary[] = csv_escape('品目名');
        $csv_ary[] = csv_escape('入荷数');
        $csv_ary[] = csv_escape('備考');
        $csv_ary[] = csv_escape('出荷消込ID');
        $csv_ary[] = csv_escape('ユーザーCD');
        $csv_ary[] = csv_escape('ユーザー名');
        $csv_ary[] = csv_escape('預り証No.');
        $csv_ary[] = csv_escape('入出荷数');
        $csv_ary[] = csv_escape('登録利用者ID');
        $csv_ary[] = csv_escape('登録所属会社ID');
        $csv_ary[] = csv_escape('登録日付');
        $csv_ary[] = csv_escape('登録時間');
        $csv_ary[] = csv_escape('登録プログラムID');
        $csv_ary[] = csv_escape('更新利用者ID');
        $csv_ary[] = csv_escape('更新所属会社ID');
        $csv_ary[] = csv_escape('更新日付');
        $csv_ary[] = csv_escape('更新時間');
        $csv_ary[] = csv_escape('更新プログラムID');

        $ary[] = implode(",", $csv_ary);

        foreach ($list as $row){
            $query02 = '';
            $query03 = '';
            $row01 = array();
            $row02 = array();
            $row03 = array();
            // 0301
            $row01 = $this->find_one('d0301', array('denno' => $row['denno']));
            // 0302
            $query02 = $this->db->get_where('d0302', array('denno' => $row['denno']));
            //送り先
            $item_okuri = $this->find_one( "m0005", array("id" => $row['okuri_id']) ,"cd, mei1");
            //SP
            $item_syukosp = $this->find_one( "m0005", array("id" => $row['syukosp_id']) ,"cd, mei1");
            if ($query02->num_rows() > 0){
                foreach ($query02->result_array() as $row02){
                    // 0303
                    $query03 = $this->db->get_where('d0303', array('seq' => $row02['seq']));
                    //品目
                    $item_hin = $this->find_one( "m0004", array("id" => $row02['hin_id']) ,"cd, mei");

                    if ($query03->num_rows() > 0){
                        foreach ($query03->result_array() as $row03){

                            $csv_ary = array();
                            $csv_ary[] = csv_escape('回収データ');
                            $csv_ary[] = csv_escape($row['denku_name']);
                            $csv_ary[] = csv_escape($row['denno']);
                            $csv_ary[] = csv_escape($row['grp_name']);
                            $csv_ary[] = csv_escape($row['plant_name']);
                            $csv_ary[] = (isset($item_okuri['cd'])) ? csv_escape($item_okuri['cd']) : '';
                            $csv_ary[] = (isset($item_okuri['mei1'])) ? csv_escape($item_okuri['mei1']) : '';
                            $csv_ary[] = (isset($item_syukosp['cd'])) ? csv_escape($item_syukosp['cd']) : '';
                            $csv_ary[] = (isset($item_syukosp['mei1'])) ? csv_escape($item_syukosp['mei1']) : '';
                            $csv_ary[] = csv_escape($row['bin']);
                            $csv_ary[] = csv_escape($row['daiko_denno']);
                            $csv_ary[] = csv_escape($row['syaban']);

                            $csv_ary[] = csv_escape($row02['seq']);
                            $csv_ary[] = (isset($item_hin['cd'])) ? csv_escape($item_hin['cd']) : '';
                            $csv_ary[] = (isset($item_hin['mei'])) ? csv_escape($item_hin['mei']) : '';
                            $csv_ary[] = csv_escape($row02['nyuka_su']);
                            $csv_ary[] = csv_escape($row02['biko']);

                            $csv_ary[] = csv_escape($row03['syuka_id']);
                            //ユーザー
                            $item_usr = $this->find_one( "m0006", array("id" => $row03['user_id']) ,"cd, mei");
                            $csv_ary[] = (isset($item_usr['cd'])) ? csv_escape($item_usr['cd']): '';
                            $csv_ary[] = (isset($item_usr['mei'])) ? csv_escape($item_usr['mei']): '';
                            $csv_ary[] = csv_escape($row03['azu_no']);
                            $csv_ary[] = csv_escape($row03['syuka_su']);
                            $csv_ary[] = csv_escape($row03['ins_riyo_id']);
                            $csv_ary[] = csv_escape($row03['ins_syozoku']);
                            $csv_ary[] = csv_escape($row03['ins_ymd']);
                            $csv_ary[] = csv_escape($row03['ins_time']);
                            $csv_ary[] = csv_escape($row03['ins_pgm_id']);
                            $csv_ary[] = csv_escape($row03['upd_riyo_id']);
                            $csv_ary[] = csv_escape($row03['upd_syozoku']);
                            $csv_ary[] = csv_escape($row03['upd_ymd']);
                            $csv_ary[] = csv_escape($row03['upd_time']);
                            $csv_ary[] = csv_escape($row03['upd_pgm_id']);

                            $ary[] = implode(",", $csv_ary);


                        }
                    }
                    continue;
                }
            }
            else{
                continue;
            }

        }

        $csv = implode("\n", $ary);

        //出力
        header("Cache-Control: public");
        header("Pragma: public");
        header("Content-type: application/x-msexcel-csv");
        header("Content-Disposition: attachment; filename=".$csv_file_name);
        echo $csv;
     }
/*---------------------------------------------------------*
 * 1件取得
 *
 *--------------------------------------------------------*/
    function find_one( $table = '', $where = '' ,$select = ''){
        $ary = array();
        if ($table == '' || $where == ''){
            return $ary;
        }
        if ($select == null){
            $this->db->select('*');
        }
        else{
            $this->db->select($select);
        }
        $query = $this->db->get_where( $table, $where, 1 );
        if ( $query->num_rows() > 0 ){
            return $query->row_array();
        }
        else{
            return $ary;
        }
    }
    /*---------------------------------------------------------*
     * ストックSPパーツ取得
     * @HTML表示部
     *
     *--------------------------------------------------------*/
     function get_m0005($id)
     {
        //stockp
        $this->db->select('m0005.mei1 as mei1');
        if ($id == ""){
            return '';
        }
        else{
            $query = $this->db->get_where( "m0005", array("id" => $id), 1 );
            if ( $query->num_rows() > 0 ){
                $ary = $query->row_array();
                return $ary['mei1'];
            }
            else{
                return '';
            }
        }
     }
    /*---------------------------------------------------------*
     * グループパーツ取得
     * @HTML表示部
     *
     *--------------------------------------------------------*/
     function get_m0002($id)
     {
        if ($id == ""){
            return '';
        }
        else{
            $this->db->select('m0002.name1 as name1');
            $query = $this->db->get_where( "m0002", array("id" => $id), 1 );
            if ( $query->num_rows() > 0 ){
                $ary = $query->row_array();
                return  $ary['name1'];
            }
            else{
                return '';
            }
        }
     }

    /*-----------------------------------------------------/
     * grp_idでセレクトボックス作成
     * ajax 送り先
    /-----------------------------------------------------*/
    function get_grp_selectbox ($ary = array(), $selected = 0){
        $str = '';
        if (count($ary) <= 0){
            return;
        }
        else{
            foreach ($ary as $val){
                if ($selected == $val['id']){
                    $selected_str = ' selected="selected"';
                }
                else{
                    $selected_str = '';
                }
                $str .= '<option value="'. $val['id']. '"'. $selected_str. '>'. $val['mei1']. '</option>'. "\n";
            }
            return $str;
        }
    }
/*-----------------------------------------------------/
 * select box
 *
 *
 *
 *
/-----------------------------------------------------*/

    /*-----------------------------------------------------/
     * group select
    /-----------------------------------------------------*/
    function get_group ($group_id = '')
    {
        $ary = array();
        $row = array();
        $this->db->select('m0002.id, m0002.name1, m0002.name2');
        $this->db->from('m0204');
        $this->db->join('m0002', 'm0204.value = m0002.id', 'inner');
        $this->db->where(array("m0204.ctrl_kbn" => 's2'));
        $this->db->where(array("m0204.ctrl_kmk1" => $this->session->userdata('m0003_id')));
        $this->db->where(array("m0204.ctrl_kmk2" => '999'));
        $this->db->where(array("m0204.ctrl_kmk3" => '999'));
        $this->db->order_by('m0002.cd asc');
        $query = $this->db->get();
        if ($query->num_rows() > 0){
            foreach ($query->result_array() as $row){
                $ary[] = $row;
            }
        }
        unset($row);
        return $ary;
    }

    /*-----------------------------------------------------/
     * plant select
    /-----------------------------------------------------*/
    function get_plant ($group_id = '')
    {
        $ary = array();
        $row = array();

        if ($group_id == ''){
            return array();
        }

        $this->db->select('m0002.id, m0002.name1, m0002.name2');
        $this->db->from('m0204');
        $this->db->join('m0002', 'm0204.value = m0002.id', 'inner');
        $this->db->where(array("m0204.ctrl_kbn" => "sh2"));
        $this->db->where(array("m0204.ctrl_kmk1" => $group_id));
        $this->db->where(array("m0204.ctrl_kmk2" => $this->session->userdata('m0003_id')));
        $this->db->where(array("m0204.ctrl_kmk3" => '999'));
        $this->db->order_by('m0002.cd asc');
        $query = $this->db->get();
        if ($query->num_rows() > 0){
            foreach ($query->result_array() as $row){
                $ary[] = $row;
            }
        }
        unset($row);
        return $ary;
    }

    /*-----------------------------------------------------/
     * denku select
    /-----------------------------------------------------*/
    function get_denku ()
    {
        $ary = array();
        $row = array();
        $this->db->select('m0002.id, m0002.name1, m0002.name2');
        $this->db->from('m0204');
        $this->db->join('m0002', 'm0204.value = m0002.id', 'inner');
        $this->db->where(array("m0204.ctrl_kbn" => "s1"));
        $this->db->where(array("m0204.ctrl_kmk1" => $this->session->userdata('m0003_id')));
        $this->db->where(array("m0204.ctrl_kmk2" => 'lmr02020'));
        $this->db->where(array("m0204.ctrl_kmk3" => '999'));
        $this->db->order_by('m0002.cd asc');
        $query = $this->db->get();
        if ($query->num_rows() > 0){
            foreach ($query->result_array() as $row){
                $ary[] = $row;
            }
        }
        unset($row);
        return $ary;
    }

    /*-----------------------------------------------------/
     * from select
    /-----------------------------------------------------*/
    function get_from ($plant_id = '', $denku_id = '')
    {

        $ary = array();
        $row = array();

        if ($plant_id == '' || $denku_id == ''){
            return array();
        }

        $this->db->select('m0005.id, m0005.mei1, m0005.mei2, m0005.ini');
        $this->db->from('m0204');
        $this->db->join('m0005', 'm0204.value = m0005.id', 'inner');
        $this->db->where("m0204.ctrl_kbn", "s11");
        $this->db->where("m0204.ctrl_kmk1", $plant_id);
        $this->db->where("m0204.ctrl_kmk2", $denku_id);
        $this->db->where("m0204.ctrl_kmk3", '999');
        $this->db->order_by('m0005.cd asc');
        $query = $this->db->get();
        if ($query->num_rows() > 0){
            foreach ($query->result_array() as $row){
                $ary[] = $row;
            }
        }

        unset($row);
        return $ary;
    }

    /*-----------------------------------------------------/
     * to select
    /-----------------------------------------------------*/
    function get_to ($plant_id = '', $denku_id = '')
    {

        $ary = array();
        $row = array();

        if ($plant_id == '' || $denku_id == ''){
            return array();
        }
        $this->db->select('m0005.id, m0005.mei1, m0005.mei2, m0005.ini');
        $this->db->from('m0204');
        $this->db->join('m0005', 'm0204.value = m0005.id', 'inner');
        $this->db->where(array("m0204.ctrl_kbn" => "s12"));
        $this->db->where(array("m0204.ctrl_kmk1" => $plant_id));
        $this->db->where(array("m0204.ctrl_kmk2" => $this->session->userdata('m0003_id')));
        $this->db->where(array("m0204.ctrl_kmk3" => $denku_id));
        $this->db->order_by('m0005.cd asc');
        $query = $this->db->get();
        if ($query->num_rows() > 0){
            foreach ($query->result_array() as $row){
                $ary[] = $row;
            }
        }
        unset($row);
        return $ary;
    }


/*-----------------------------------------------------/
 * ajax
 *
 *
 *
 *
 *
 *
 *
 *
/-----------------------------------------------------*/

    /*-----------------------------------------------------/
     * group
    /-----------------------------------------------------*/
    function get_group_html ($selected = 0)
    {
        if ($selected == 0 || $selected == ''){
            $str = '<option value="" selected="selected">選択してください</option>';
        }
        else{
            $str = '<option value="">選択してください</option>';
        }
        $ary = array();

        $ary = $this->get_group();
        foreach ($ary as $val){
            if ($selected == $val['id']){
                $selected_str = ' selected="selected"';
            }
            else{
                $selected_str = '';
            }

            $str .= '<option value="'. $val['id']. '"'. $selected_str. '>'. $val['name1']. "　". $val['name2']. '</option>'. "\n";
        }
        return $str;
    }
    /*-----------------------------------------------------/
     * plant
     * ajax
    /-----------------------------------------------------*/
    function get_plant_html ($group_id = '', $selected = 0){
        if ($selected == 0 || $selected == ''){
            $str = '<option value="" selected="selected">選択してください</option>';
        }
        else{
            $str = '<option value="">選択してください</option>';
        }
        $ary = array();
        if ($group_id == ''){
            return $str;
        }
        $ary = $this->get_plant($group_id);
        foreach ($ary as $val){
            if ($selected == $val['id']){
                $selected_str = ' selected="selected"';
            }
            else{
                $selected_str = '';
            }

            $str .= '<option value="'. $val['id']. '"'. $selected_str. '>'. $val['name1']. $val['name2']. '</option>'. "\n";

        }
        return $str;
    }

    /*-----------------------------------------------------/
     * denku select
    /-----------------------------------------------------*/
    function get_denku_html ($selected = 0)
    {
        if ($selected == 0 || $selected == ''){
            $str = '<option value="" selected="selected">すべて対象にする</option>';
        }
        else{
            $str = '<option value="">すべて対象にする</option>';
        }
        $ary = array();

        $ary = $this->get_denku();
        foreach ($ary as $val){
            if ($selected == $val['id']){
                $selected_str = ' selected="selected"';
            }
            else{
                $selected_str = '';
            }

            $str .= '<option value="'. $val['id']. '"'. $selected_str. '>'. $val['name1']. $val['name2']. '</option>'. "\n";
        }
        return $str;
    }

    /*-----------------------------------------------------/
     * from
     * ajax
    /-----------------------------------------------------*/
    function get_from_html ($plant_id = '', $denku_id = '', $selected = ''){

        if ($selected == 0 || $selected == ''){
            $str = '<option value="" selected="selected">選択してください</option>';
        }
        else{
            $str = '<option value="">選択してください</option>';
        }
        $ary = array();
        if ($plant_id == '' || $denku_id == ''){
            return $str;
        }

        $ary = $this->get_from($plant_id, $denku_id);

        foreach ($ary as $val){
            if ($selected == $val['id']){
                $selected_str = ' selected="selected"';
            }
            else{
                $selected_str = '';
            }
            $str .= '<option value="'. $val['id']. '"'. $selected_str. '>'. $val['ini']. '</option>'. "\n";
        }
        return $str;
    }

    /*-----------------------------------------------------/
     * to
     * ajax
    /-----------------------------------------------------*/
    function get_to_html ($plant_id = '', $denku_id = '', $selected = ''){
        if ($selected == 0 || $selected == ''){
            $str = '<option value="" selected="selected">選択してください</option>';
        }
        else{
            $str = '<option value="">選択してください</option>';
        }
        $ary = array();
        if ($plant_id == '' || $denku_id == ''){
            return $str;
        }
        $ary = $this->get_to($plant_id, $denku_id);
        foreach ($ary as $val){
            if ($selected == $val['id']){
                $selected_str = ' selected="selected"';
            }
            else{
                $selected_str = '';
            }
            $str .= '<option value="'. $val['id']. '"'. $selected_str. '>'. $val['ini']. '</option>'. "\n";
        }
        return $str;
    }

}
?>