<?php

class Lmr02210_model extends Model {

    var $group = array();
    var $plant = array();
    var $denno_ary = array();

    function __construct()
    {
        parent::Model();
    }

    /*---------------------------------------------------------*
     * wordを分割して配列へ
     *
     *--------------------------------------------------------*/
     function sep_word ($ary)
     {
        $word_ary = explode("&", $ary['word']);
        foreach ($word_ary as $val){
            $ary1 = explode("=", $val);
            if (count($ary1) > 0){
                if (isset($ary1[1])){
                    $ary[$ary1[0]] = $ary1[1];
                }
            }
        }
        return $ary;
     }

    /*---------------------------------------------------------*
     * パラメータの設定
     * c7:  出荷年月日
     * c8:  入力年月日
     * s1:  グループ
     * s2:  プラント
     * s3:  検索区分
     * s10: 伝票番号
     * s11: 出荷年月日
     * s12: 出荷年月日
     * s13: 入力年月日
     * s14: 入力年月日
     *--------------------------------------------------------*/
     function set_param ($ary)
     {

        $ary['c7'] = (empty($ary['c7'])) ? $this->input->post("c7"): $ary['c7'];
        $ary['c8'] = (empty($ary['c8'])) ? $this->input->post("c8"): $ary['c8'];
        $ary['s1'] = (empty($ary['s1'])) ? $this->input->post("s1"): $ary['s1'];
        $ary['s2'] = (empty($ary['s2'])) ? $this->input->post("s2"): $ary['s2'];
        $ary['s3'] = (empty($ary['s3'])) ? $this->input->post("s3"): $ary['s3'];
        $ary['s4'] = (empty($ary['s4'])) ? $this->input->post("s4"): $ary['s4'];
        $ary['s10'] = (empty($ary['s10'])) ? $this->input->post("s10"): $ary['s10'];
        $ary['s11'] = (empty($ary['s11'])) ? $this->input->post("s11"): $ary['s11'];
        $ary['s12'] = (empty($ary['s12'])) ? $this->input->post("s12"): $ary['s12'];
        $ary['s13'] = (empty($ary['s13'])) ? $this->input->post("s13"): $ary['s13'];
        $ary['s14'] = (empty($ary['s14'])) ? $this->input->post("s14"): $ary['s14'];
        return $ary;
     }
    /*---------------------------------------------------------*
     * URL作成
     *
     *--------------------------------------------------------*/
     function set_url ($ary)
     {
         return  's1='. $ary['s1']
            . '&s2='. $ary['s2']
            . '&s3='. $ary['s3']
            . '&s4='. $ary['s4']
            . '&s10='. $ary['s10']
            . '&s11='. $ary['s11']
            . '&s12='. $ary['s12']
            . '&s13='. $ary['s13']
            . '&s14='. $ary['s14']
            . '&c7='. $ary['c7']
            . '&c8='. $ary['c8'];
     }

    /*---------------------------------------------------------*
     * set select box
     *
     *--------------------------------------------------------*/
     function set_drop ($ary)
     {
        $this->group = $this->get_group_html($ary['s1']);

        if (isset($ary['s1'])){
            $this->plant = $this->get_plant_html($ary['s1'], $ary['s2']);
        }

     }

    /*---------------------------------------------------------*
     * validation
     *
     *--------------------------------------------------------*/
     function validation ($ary)
     {
        $err = 0;
        if (!$this->validation->required($ary['s1'])){
            $this->validation->custom_error('グループは必須です');
            $err = 1;
        }
        if (!$this->validation->required($ary['s2'])){
            $this->validation->custom_error('プラント分は必須です');
            $err = 1;
        }
        if (!$this->validation->required($ary['s3'])){
            $this->validation->custom_error('検索区分は必須です');
            $err = 1;
        }
        if ($ary['c6'] == 'y'){
            if (!$this->validation->required($ary['s10'])){
                $this->validation->custom_error('伝票番号を入力してください');
                $err = 1;
            }
        }

        if ($ary['c7'] == 'y'){
            if (!$this->validation->required($ary['s11']) && !$this->validation->required($ary['s12'])){
                $this->validation->custom_error('出荷年月日を指定してください');
                $err = 1;
            }
            else{
                if (!$this->validation->hiduke($ary['s11']) || !$this->validation->hiduke($ary['s12'])){
                    $this->validation->custom_error('出荷年月日の形式に誤りがあります');
                    $err = 1;
                }
                else{
                    if ($ary['s11'] > $ary['s12']){
                        $this->validation->custom_error('出荷年月日の範囲に誤りがあります');
                        $err = 1;
                    }
                }
            }
        }
        if ($ary['c8'] == 'y'){
            if (!$this->validation->required($ary['s13']) && !$this->validation->required($ary['s14'])){
                $this->validation->custom_error('入力年月日を指定してください');
                $err = 1;
            }
            else{
                if (!$this->validation->hiduke($ary['s13']) || !$this->validation->hiduke($ary['s14'])){
                    $this->validation->custom_error('入力年月日の形式に誤りがあります');
                    $err = 1;
                }
                else{
                    if ($ary['s13'] > $ary['s14']){
                        $this->validation->custom_error('入力年月日の範囲に誤りがあります');
                        $err = 1;
                    }
                }
            }

        }

        // SAP対象判定 伝票NO取得
        $this->db->select("d0602.denno");
        if ($ary['s4'] == 3){
            $this->db->where('m0004.sap_renkei_kbn', '1');
        }
        elseif($ary['s4'] == 4){
            $this->db->where('m0004.sap_renkei_kbn', '2');
        }
        $this->db->where('d0601.to_id', $this->session->userdata("m0003_syozoku_id"));
        $this->db->where('d0601.syori_kbn', "4");
        $this->db->where('d0601.grp_id', $ary['s1']);
        $this->db->where('d0601.plant_id', $ary['s2']);

        $query = $this->db->from("d0602");
        $query = $this->db->join("m0004", "d0602.hin_id=m0004.id");
        $query = $this->db->join("d0601", "d0602.denno=d0601.denno");
        $query = $this->db->get();
        if ($query->num_rows() > 0)
        {
            foreach ($query->result_array() as $row)
            {
                $this->denno_ary[] = $row['denno'];
            }
        }
        else{

            $err = 1;
        }
        return $err;
     }
    /*---------------------------------------------------------*
     * SQL
     * @select
     *
     *--------------------------------------------------------*/
     function sql_select ()
     {
        $this->db->select('d0601.denno as denno');
        $this->db->select('d0601.denku_id as denku_id');
        $this->db->select('d0601.grp_id as grp_id');
        $this->db->select('d0601.plant_id as plant_id');
        $this->db->select('d0601.ido_ymd as ido_ymd');
        $this->db->select('d0601.from_id as from_id');
        $this->db->select('d0601.to_id as to_id');
        $this->db->select('d0601.irai_id as irai_id');
        $this->db->select('d0601.genka_id as genka_id');
        $this->db->select('d0601.nonyu as nonyu');
        $this->db->select('d0601.ins_ymd as ins_ymd');
        $this->db->select('d0601.ins_time as ins_time');
        $this->db->select('d0601.horyu_kbn as horyu_kbn');

     }
    /*---------------------------------------------------------*
     * SQL
     * @from join
     *
     *--------------------------------------------------------*/
     function sql_from_join ()
     {
        $this->db->from('d0601');
     }
    /*---------------------------------------------------------*
     * SQL
     * @where
     *
     *--------------------------------------------------------*/
     function sql_where ($ary)
     {


        $this->db->where('d0601.to_id', $this->session->userdata("m0003_syozoku_id"));
        $this->db->where('d0601.syori_kbn', "4");
        $this->db->where_in("d0601.denno", $this->denno_ary);
        if (!empty($ary['s1'])){
            $this->db->where('d0601.grp_id', $ary['s1']);
        }
        if (!empty($ary['s2'])){
            $this->db->where('d0601.plant_id', $ary['s2']);
        }

        //検索区分
        if (!empty($ary['s3'])){
            if ($ary['s3'] == 3){
                $this->db->where('d0601.denpyo_ymd', '');
            }
            elseif($ary['s3'] == 4){
                $this->db->where('d0601.denpyo_ymd<>', '');
            }

        }

        if ($ary['s10'] != ""){
            $this->db->where('d0601.denno', $ary['s10']);
        }

        if ($ary['c7'] == 'y' && (!empty($ary['s11']) || !empty($ary['s12']))){
            if (!empty($ary['s11'])){
                $this->db->where('d0601.ido_ymd>=', ymd_del_c($ary['s11']));
            }
            if (!empty($ary['s12'])){
                $this->db->where('d0601.ido_ymd<=', ymd_del_c($ary['s12']));
            }
        }

        if ($ary['c8'] == 'y' &&  (!empty($ary['s13']) || !empty($ary['s14']))){
            if (!empty($ary['s13'])){
                $this->db->where('d0601.ins_ymd>=', ymd_del_c($ary['s13']));
            }
            if (!empty($ary['s14'])){
                $this->db->where('d0601.ins_ymd<=', ymd_del_c($ary['s14']));
            }
        }
     }

    /*---------------------------------------------------------*
     * SQL
     * @組み立て
     *
     *--------------------------------------------------------*/
     function find ($ary, $per_page, $page_offset)
     {



        $this->sql_select();

        //cache start
        $this->db->start_cache();

        $this->sql_from_join();

        $this->sql_where($ary);

        //cache stop
        $this->db->stop_cache();

        $this->db->order_by('denno asc');

        if ($page_offset != null){
            $page_offset = (int)$page_offset;
        }
        $this->db->limit($per_page, $page_offset);

        $query = $this->db->get();

        //全件数 cache使用
        $total = $this->db->count_all_results();

        $this->db->flush_cache();

        return array($query, $total);
     }

     function set_pagenation ($url, $total, $per_page, $page_offset)
     {
        return array(
            "base_url" => $url. '/',
            "total_rows" => $total,
            "page_offset" => $page_offset,
            "per_page" => $per_page,
            "page_prev" => '',
            "page_next" => '',
            "full_tag_open" => '',
            "full_tag_close" => '',
            "first_link" => '<img src="'. base_url(). 'images/popup/control_first.gif" width="16" height="16" />',
            "first_tag_open" => '<li class="first">',
            "first_tag_close" => '</li>',
            "last_link" => '<img src="'. base_url(). 'images/popup/control_last.gif" width="16" height="16" />',
            "last_tag_open" => '<li class="last">',
            "last_tag_close" => '</li>',
            "next_link" => '<img src="'. base_url(). 'images/popup/control_next.gif" width="16" height="16" />',
            "next_tag_open" => '<li class="next">',
            "next_tag_close" => '</li>',
            "prev_link" => '<img src="'. base_url(). 'images/popup/control_back.gif" width="16" height="16" />',
            "prev_tag_open" => '<li class="prev">',
            "prev_tag_close" => '</li>',
            "cur_tag_open" => '<strong> ',
            "cur_tag_close" => '</strong>',
            "num_tag_open" => '<li>',
            "num_tag_close" => '</li>',
            "num_full_tag_open" => '<li class="numbers"><ol start="1">',
            "num_full_tag_close" => '</ol></li>',
            "a_tag_push" => ''
         );
     }
    /*---------------------------------------------------------*
     * 和暦
     *
     *
     *--------------------------------------------------------*/
        function to_wareki($ymd = '')
        {
            if ($ymd == ""){
                $ymd = date("Ymd");
            }
            $y = substr($ymd, 0, 4);
            $m = substr($ymd, 4, 2);
            $d = substr($ymd, 6, 2);
            //年月日を文字列として結合
            $ymd = sprintf("%02d%02d%02d", $y, $m, $d);
            if ($ymd <= "19120729") {
                $gg = "明治";
                $yy = $y - 1867;
            } elseif ($ymd >= "19120730" && $ymd <= "19261224") {
                $gg = "大正";
                $yy = $y - 1911;
            } elseif ($ymd >= "19261225" && $ymd <= "19890107") {
                $gg = "昭和";
                $yy = $y - 1925;
            } elseif ($ymd >= "19890108" && $ymd <= "20190499") {
              $gg = "平成";
              $yy = $y - 1988;
            } elseif ($ymd >= "20190501") {
              $gg = "令和";
              $yy = $y - 2018;
            }
            $wareki = "{$gg} {$yy} 年 {$m} 月 {$d} 日";
            return $wareki;
        }


     function write_fnc($str, $x, $y, $height)
     {
        $this->pdf->SetXY($x,$y);
        $this->pdf->Write($height,u8_sj($str));
     }
     function add_page($d0601_data, $d0601_list, $m0005_ary = array(), $title = 1)
     {

        if ($d0601_data['horyu_kbn'] == "1"){
            $horyu_kbn = ' *';
        }
        else{
            $horyu_kbn = '';
        }

        //sap_renkei
        if ($d0601_data['sap_renkei'] == "2"){
            /*---------------------------------------------------------*
             * SAP連携対象外
             *--------------------------------------------------------*/
            $this->pdf->SetXY(17, 10);
            $title = 'SAP連携対象外';
            $this->pdf->SetTitle($title);
            $this->pdf->SetFont(GOTHIC,'',10);
            $this->pdf->Cell(180, 10, u8_sj($title), 0, 0, 'L');
        }
        /*---------------------------------------------------------*
         * 納品書タイトル
         *--------------------------------------------------------*/
        $this->pdf->SetXY(17, 10);
        $denku_name = $d0601_data['denku']['name1'];
        $title = '検 収 作 業 報 告 書';
        $this->pdf->SetTitle($title);
        $this->pdf->SetFont(GOTHIC,'',17);
        $this->pdf->Cell(180, 10, u8_sj($title), 0, 0, 'C');

        /*---------------------------------------------------------*
         * 送り先会社情報
         *--------------------------------------------------------*/
        $this->pdf->SetXY(17, $this->pdf->GetY() + 20);
        $this->pdf->SetFont(GOTHIC,'',11);
        $this->pdf->Cell(50, 5, u8_sj($d0601_data['plant']['name1']), 0, 1, 'L');
        $this->pdf->SetFont(GOTHIC,'',11);
        $this->pdf->Cell(50, 5, u8_sj($d0601_data['plant']['name2']), 'B', 0, 'L');
        $this->pdf->Cell(15, 5, u8_sj('御中'), 'B', 1, 'R');


        /*---------------------------------------------------------*
         * 伝票No
         *--------------------------------------------------------*/
        $this->pdf->SetXY(150, 0);
        $this->pdf->SetFont(GOTHIC,'',9);
        $this->pdf->Cell(35, 5, u8_sj('伝票 No. '. $d0601_data['denno']), 0, 0, 'R');
        $this->pdf->Cell(12, 5, u8_sj('('. $d0601_data['count_str_pdf']. ')'), 0, 1, 'R');


        /*---------------------------------------------------------*
         * 会社情報
         *--------------------------------------------------------*/
        $this->pdf->SetXY(135, $this->pdf->GetY() + 23);
        $this->pdf->SetFont(GOTHIC,'',11);
        $this->pdf->Cell(55, 5, u8_sj($d0601_data['to']['mei1']), 0, 1, 'L');
        $this->pdf->SetFont(GOTHIC,'',11);
        $this->pdf->SetXY(135, $this->pdf->GetY());
        $this->pdf->Cell(55, 5, u8_sj($d0601_data['to']['mei2']), 0, 1, 'L');



        /*---------------------------------------------------------*
         * グループ　プラント　From　To　依頼元　原価センターなど
         *--------------------------------------------------------*/
        $this->pdf->SetFont(GOTHIC,'',9);
        $this->pdf->SetXY(17, $this->pdf->GetY() + 10);
        $this->pdf->Cell(20, 7, u8_sj(' 検 収 日 '), 1, 0, 'C');
        $this->pdf->Cell(38, 7, u8_sj($this->to_wareki($d0601_data['ido_ymd'])), 1, 0, 'L');


        /*---------------------------------------------------------*
         * 品目コード　品目　出荷数　備考
         *--------------------------------------------------------*/
        $this->pdf->SetFont(GOTHIC,'',8);
        $this->pdf->SetXY(17, $this->pdf->GetY() + 10);
        $this->pdf->Cell(20, 8, u8_sj('品目コード'), 'LRT', 0, 'C');
        $this->pdf->Cell(60, 8, u8_sj('  品                 目  '), 1, 0, 'C');
        $this->pdf->Cell(27, 8, u8_sj('   検  収  数  量   '), 1, 0, 'C');
        $this->pdf->Cell(27, 8, u8_sj('   良  品  数   '), 'TB', 0, 'C');
        $this->pdf->Cell(27, 8, u8_sj('   不  良  数   '), 1, 0, 'C');
        $this->pdf->Cell(19, 8, u8_sj('  伝票区分  '), 1, 1, 'C');


            for($c = 0;$c < 25;$c++){
                $cd = (isset($d0601_list[$c]['cd'])) ? $d0601_list[$c]['cd']: '';
                $mei = (isset($d0601_list[$c]['mei'])) ? $d0601_list[$c]['mei']: '';
                $kikaku = (isset($d0601_list[$c]['kikaku'])) ? $d0601_list[$c]['kikaku']: '';
                $ido_su = (isset($d0601_list[$c]['ido_su'])) ? nf($d0601_list[$c]['ido_su']): '';
                $ryo_su = (isset($d0601_list[$c]['ryo_su'])) ? nf($d0601_list[$c]['ryo_su']): '';
                $furyo_su = (isset($d0601_list[$c]['furyo_su'])) ? nf($d0601_list[$c]['furyo_su']): '';
                /* 2009/12/30
                $biko = (isset($d0601_list[$c]['biko'])) ? $d0601_list[$c]['biko']: '';
                $biko1 = mb_substr($biko, 0, 8, 'UTF-8');
                $biko2 = mb_substr($biko, 8, 8, 'UTF-8');
                */
                if ($mei != ''){
                    $denku_name = $d0601_data['denku']['name1'];
                }
                else{
                    $denku_name = '';
                }
                $tani = (isset($d0601_list[$c]['tani'])) ? $d0601_list[$c]['tani']: '';


                /*---------------------------------------------------------*
                 * 品目コード　品目　出荷数　備考　中身
                 *--------------------------------------------------------*/
                $y = $this->pdf->GetY();

                $this->pdf->SetXY(17, $y);
                $this->pdf->SetFont(GOTHIC,'',9);
                $this->pdf->Cell(20, 8, u8_sj($cd), 1, 0, 'L');
                $this->pdf->SetXY(37, $y);
                $this->pdf->SetFont(GOTHIC,'',8);
                $this->pdf->Cell(60, 4, u8_sj($mei), 'LRT', 2, 'L');
                $this->pdf->SetFont(GOTHIC,'',7);
                $this->pdf->Cell(60, 4, u8_sj($kikaku), 'LRB', 0, 'L');

                $this->pdf->SetXY($this->pdf->GetX(), $y);
                $this->pdf->SetFont(GOTHIC,'',8);
                $this->pdf->Cell(27, 8, u8_sj($ido_su. ' '. $tani), 1, 0, 'R');
                $this->pdf->SetFont(GOTHIC,'',8);
                $this->pdf->Cell(27, 8, u8_sj($ryo_su. ' '. $tani), 'TB', 0, 'R');
                $this->pdf->SetFont(GOTHIC,'',8);
                $this->pdf->Cell(27, 8, u8_sj($furyo_su. ' '. $tani), 1, 0, 'R');

                $this->pdf->SetFont(GOTHIC,'',8);
                $this->pdf->Cell(19, 8, u8_sj($denku_name), 'LRB', 1, 'L');

            }

        $y = $this->pdf->GetY() + 2;


        /*---------------------------------------------------------*
         * フッター　記事
         *--------------------------------------------------------*/
        $this->pdf->SetFont(GOTHIC,'',8);
        $this->pdf->SetXY(17, $y);
        $this->pdf->Cell(140, 5, u8_sj('(記事)'), 'TLR', 1, 'L');
        $this->pdf->Cell(140, 15, u8_sj(''), 'BLR', 0, 'L');
        /*---------------------------------------------------------*
         * 空欄
         *--------------------------------------------------------*/
        $this->pdf->SetXY($this->pdf->GetX() + 2, $y);
        $this->pdf->Cell(19, 20, '', 1, 0, 'L');
        $this->pdf->Cell(19, 20, '', 1, 1, 'L');




     }


    /*---------------------------------------------------------*
     * PDF 送り状発行
     *
     *--------------------------------------------------------*/
     function okuri_hakkou_pdf($d0601_ary, $m0005_ary)
     {
        require(APPPATH.'fpdf/mbfpdf.php');
        define('FPDF_FONTPATH', 'fpdf/font/');
        $this->pdf = new MBFPDF('P', 'mm', 'A4');
        $this->pdf->SetMargins(17.0, 25.0, 10.0);
        $this->pdf->AddMBFont(GOTHIC ,'SJIS');
        $this->pdf->SetAutoPageBreak(false, 20.0);

        //default
        $hakkou[] = 1;

        foreach($hakkou as $hval){

            foreach ($d0601_ary as $key => $val){

                $val['d0601_data']['count_str'] = $val['d0602_list_total'];
                foreach ($val['d0602_list'] as $val2){

                    if ($hval == 1){
                        $this->pdf->AddPage();
                        $val['d0601_data']['count_str_pdf'] = $val2['count']. '/'. $val['d0601_data']['count_str'];
                        $this->add_page($val['d0601_data'], $val2['list'], $m0005_ary, $hval);
                    }
                }

            }
        }

        $this->pdf->Output('nouhinsyo.pdf', 'I');
     }


     /*---------------------------------------------------------*
     * SQL
     * 品目の取得
     * d0202
     * 引数:seq
     *
     *--------------------------------------------------------*/
    function get_d0602_pdf_list ($denno)
    {
        $ary = array();
        $this->db->select('m0004.mei as mei, m0004.kikaku as kikaku');
        $this->db->select('d0602.biko as biko, m0004.tani as tani, m0004.sap_renkei_kbn as sap_renkei_kbn');
        $this->db->select('m0004.cd as cd');
        $this->db->select('d0602.yobi_2 as yobi2');
        $this->db->select('d0602.ido_su as ido_su');
        $this->db->from('d0602');
        $this->db->join('m0004', 'd0602.hin_id=m0004.id', 'inner');
        $this->db->where(array("d0602.denno" => $denno));
        $query = $this->db->get();
        if ($query->num_rows() > 0)
        {
            foreach ($query->result_array() as $row)
            {
                $d9001 = array();

                if ($row['yobi2'] == ""){
                    $row['ryo_su']      = '';
                    $row['furyo_su']    = '';
                    $row['upd_ymd']     = '';
                }
                else{

                    $d9001 = $this->find_one('d9001', array("syuyaku_no" => $row['yobi2']) ,'ryo_su, furyo_su, upd_ymd');
                    if (count($d9001) <= 0){
                        $row['ryo_su']      = '';
                        $row['furyo_su']    = '';
                        $row['upd_ymd']     = '';
                    }
                    else{
                        $row['ryo_su']      = $d9001['ryo_su'];
                        $row['furyo_su']    = $d9001['furyo_su'];
                        $row['upd_ymd']     = $d9001['upd_ymd'];
                    }
                }

                $ary[] = $row;
            }
        }
        return $ary;
    }

     /*---------------------------------------------------------*
     * SQL
     * 取引先マスタ
     *
     *--------------------------------------------------------*/
    function get_m0005_pdf ()
    {
        $ary = array();
        $this->db->where(array("id" => $this->session->userdata('m0003_syozoku_id')));
        $this->db->limit(1);
        $query = $this->db->get('m0005');
        if ( $query->num_rows() > 0 ){
            return $query->row_array();
        }
        else{
            return false;
        }
    }


/*---------------------------------------------------------*
 * 1件取得
 *
 *--------------------------------------------------------*/
    function find_one( $table = '', $where = '' ,$select = ''){
        $ary = array();
        if ($table == '' || $where == ''){
            return $ary;
        }
        if ($select == null){
            $this->db->select('*');
        }
        else{
            $this->db->select($select);
        }
        $query = $this->db->get_where( $table, $where, 1 );
        if ( $query->num_rows() > 0 ){
            return $query->row_array();
        }
        else{
            return $ary;
        }
    }

    /*---------------------------------------------------------*
     * ストックSPパーツ取得
     * @HTML表示部
     *
     *--------------------------------------------------------*/
     function get_m0005($id)
     {
        //stockp
        $this->db->select('m0005.mei1 as mei1');
        if ($id == ""){
            return '';
        }
        else{
            $query = $this->db->get_where( "m0005", array("id" => $id), 1 );
            if ( $query->num_rows() > 0 ){
                $ary = $query->row_array();
                return $ary['mei1'];
            }
            else{
                return '';
            }
        }
     }
    /*---------------------------------------------------------*
     * グループパーツ取得
     * @HTML表示部
     *
     *--------------------------------------------------------*/
     function get_m0002($id)
     {
        if ($id == ""){
            return '';
        }
        else{
            $this->db->select('m0002.name1 as name1');
            $query = $this->db->get_where( "m0002", array("id" => $id), 1 );
            if ( $query->num_rows() > 0 ){
                $ary = $query->row_array();
                return  $ary['name1'];
            }
            else{
                return '';
            }
        }
     }

    /*-----------------------------------------------------/
     * grp_idでセレクトボックス作成
     * ajax 送り先
    /-----------------------------------------------------*/
    function get_grp_selectbox ($ary = array(), $selected = 0){
        $str = '';
        if (count($ary) <= 0){
            return;
        }
        else{
            foreach ($ary as $val){
                if ($selected == $val['id']){
                    $selected_str = ' selected="selected"';
                }
                else{
                    $selected_str = '';
                }
                $str .= '<option value="'. $val['id']. '"'. $selected_str. '>'. $val['mei1']. '</option>'. "\n";
            }
            return $str;
        }
    }
/*-----------------------------------------------------/
 * select box
 *
 *
 *
 *
/-----------------------------------------------------*/

    /*-----------------------------------------------------/
     * group select
    /-----------------------------------------------------*/
    function get_group ($group_id = '')
    {
        $ary = array();
        $row = array();
        $this->db->select('m0002.id, m0002.name1, m0002.name2');
        $this->db->from('m0204');
        $this->db->join('m0002', 'm0204.value = m0002.id', 'inner');
        $this->db->where(array("m0204.ctrl_kbn" => 's2'));
        $this->db->where(array("m0204.ctrl_kmk1" => $this->session->userdata('m0003_id')));
        $this->db->where(array("m0204.ctrl_kmk2" => '999'));
        $this->db->where(array("m0204.ctrl_kmk3" => '999'));
        $this->db->order_by('m0002.cd asc');
        $query = $this->db->get();
        if ($query->num_rows() > 0){
            foreach ($query->result_array() as $row){
                $ary[] = $row;
            }
        }
        unset($row);
        return $ary;
    }

    /*-----------------------------------------------------/
     * plant select
    /-----------------------------------------------------*/
    function get_plant ($group_id = '')
    {
        $ary = array();
        $row = array();

        if ($group_id == ''){
            return array();
        }

        $this->db->select('m0002.id, m0002.name1, m0002.name2');
        $this->db->from('m0204');
        $this->db->join('m0002', 'm0204.value = m0002.id', 'inner');
        $this->db->where(array("m0204.ctrl_kbn" => "sh2"));
        $this->db->where(array("m0204.ctrl_kmk1" => $group_id));
        $this->db->where(array("m0204.ctrl_kmk2" => $this->session->userdata('m0003_id')));
        $this->db->where(array("m0204.ctrl_kmk3" => '999'));
        $this->db->order_by('m0002.cd asc');
        $query = $this->db->get();
        if ($query->num_rows() > 0){
            foreach ($query->result_array() as $row){
                $ary[] = $row;
            }
        }
        unset($row);
        return $ary;
    }


/*-----------------------------------------------------/
 * ajax
 *
 *
 *
 *
 *
 *
 *
 *
/-----------------------------------------------------*/

    /*-----------------------------------------------------/
     * group
    /-----------------------------------------------------*/
    function get_group_html ($selected = 0)
    {
        if ($selected == 0 || $selected == ''){
            $str = '<option value="" selected="selected">選択してください</option>';
        }
        else{
            $str = '<option value="">選択してください</option>';
        }
        $ary = array();

        $ary = $this->get_group();
        foreach ($ary as $val){
            if ($selected == $val['id']){
                $selected_str = ' selected="selected"';
            }
            else{
                $selected_str = '';
            }

            $str .= '<option value="'. $val['id']. '"'. $selected_str. '>'. $val['name1']. "　". $val['name2']. '</option>'. "\n";
        }
        return $str;
    }
    /*-----------------------------------------------------/
     * plant
     * ajax
    /-----------------------------------------------------*/
    function get_plant_html ($group_id = '', $selected = 0){
        if ($selected == 0 || $selected == ''){
            $str = '<option value="" selected="selected">選択してください</option>';
        }
        else{
            $str = '<option value="">選択してください</option>';
        }
        $ary = array();
        if ($group_id == ''){
            return $str;
        }
        $ary = $this->get_plant($group_id);
        foreach ($ary as $val){
            if ($selected == $val['id']){
                $selected_str = ' selected="selected"';
            }
            else{
                $selected_str = '';
            }

            $str .= '<option value="'. $val['id']. '"'. $selected_str. '>'. $val['name1']. $val['name2']. '</option>'. "\n";

        }
        return $str;
    }



}
?>