<?php

class Lmr02221_model extends Model {

    var $group = array();
    var $plant = array();
    var $denku = array();
    var $from  = array();
    var $to    = array();
    var $irai  = array();
    var $genka = array();

    function __construct()
    {
        parent::Model();
    }

    /*---------------------------------------------------------*
     * wordを分割して配列へ
     *
     *--------------------------------------------------------*/
     function sep_word ($ary)
     {
        $word_ary = explode("&", $ary['word']);
        foreach ($word_ary as $val){
            $ary1 = explode("=", $val);
            if (count($ary1) > 0){
                if (isset($ary1[1])){
                    $ary[$ary1[0]] = $ary1[1];
                }
            }
        }
        return $ary;
     }

    /*---------------------------------------------------------*
     * パラメータの設定
     * c6:  伝票番号
     * c8:  入力年月日
     * s1:  グループ
     * s2:  プラント
     * s3:  検索区分
     * s4:  伝票区分
     * s5:  From在庫場所
     * s10: 伝票番号
     * s11: 棚卸年月日
     * s12: 棚卸年月日
     * s13: 入力年月日
     * s14: 入力年月日
     *--------------------------------------------------------*/
     function set_param ($ary)
     {
        $ary['c6'] = (empty($ary['c6'])) ? $this->input->post("c6"): $ary['c6'];
        $ary['c8'] = (empty($ary['c8'])) ? $this->input->post("c8"): $ary['c8'];
        $ary['s1'] = (empty($ary['s1'])) ? $this->input->post("s1"): $ary['s1'];
        $ary['s2'] = (empty($ary['s2'])) ? $this->input->post("s2"): $ary['s2'];
        $ary['s3'] = (empty($ary['s3'])) ? $this->input->post("s3"): $ary['s3'];
        $ary['s4'] = (empty($ary['s4'])) ? $this->input->post("s4"): $ary['s4'];
        $ary['s5'] = (empty($ary['s5'])) ? $this->input->post("s5"): $ary['s5'];
        $ary['s10'] = (empty($ary['s10'])) ? $this->input->post("s10"): $ary['s10'];
        $ary['s11'] = (empty($ary['s11'])) ? $this->input->post("s11"): $ary['s11'];
        $ary['s12'] = (empty($ary['s12'])) ? $this->input->post("s12"): $ary['s12'];
        $ary['s13'] = (empty($ary['s13'])) ? $this->input->post("s13"): $ary['s13'];
        $ary['s14'] = (empty($ary['s14'])) ? $this->input->post("s14"): $ary['s14'];
        return $ary;
     }
    /*---------------------------------------------------------*
     * URL作成
     *
     *--------------------------------------------------------*/
     function set_url ($ary)
     {
         return  's1='. $ary['s1']
            . '&s2='. $ary['s2']
            . '&s3='. $ary['s3']
            . '&s4='. $ary['s4']
            . '&s5='. $ary['s5']
            . '&s10='. $ary['s10']
            . '&s11='. $ary['s11']
            . '&s12='. $ary['s12']
            . '&s13='. $ary['s13']
            . '&s14='. $ary['s14']
            . '&c6='. $ary['c6']
            . '&c8='. $ary['c8'];
     }

    /*---------------------------------------------------------*
     * set select box
     *
     *--------------------------------------------------------*/
     function set_drop ($ary)
     {
        $this->group = $this->lmr02221_model->get_group_html($ary['s1']);

        if (isset($ary['s1'])){
            $this->plant = $this->lmr02221_model->get_plant_html($ary['s1'], $ary['s2']);
            $this->from = $this->lmr02221_model->get_from_html($ary['s1'], $ary['s5']);
        }

        $this->denku = $this->lmr02221_model->get_denku_html('100');//棚卸調整

     }

    /*---------------------------------------------------------*
     * validation
     *
     *--------------------------------------------------------*/
     function validation ($ary)
     {
        $err = 0;
        if (!$this->validation->required($ary['s1'])){
            $this->validation->custom_error('グループは必須です');
            $err = 1;
        }
        if (!$this->validation->required($ary['s2'])){
            $this->validation->custom_error('プラント分は必須です');
            $err = 1;
        }
        if (!$this->validation->required($ary['s3'])){
            $this->validation->custom_error('検索区分は必須です');
            $err = 1;
        }
        /*
        if (!$this->validation->required($ary['s4']) || !$this->validation->numeric($ary['s4'])){
            $this->validation->custom_error('伝票区分は必須です');
            $err = 1;
        }
        */
            if (!$this->validation->required($ary['s5'])){
                $this->validation->custom_error('From在庫場所を選択してください');
                $err = 1;
            }
        if ($ary['c6'] == 'y'){
            if (!$this->validation->required($ary['s10'])){
                $this->validation->custom_error('伝票番号を入力してください');
                $err = 1;
            }
        }

            if (!$this->validation->required($ary['s11']) && !$this->validation->required($ary['s12'])){
                $this->validation->custom_error('棚卸年月日を指定してください');
                $err = 1;
            }
            else{
                if (!$this->validation->hiduke($ary['s11']) || !$this->validation->hiduke($ary['s12'])){
                    $this->validation->custom_error('棚卸年月日の形式に誤りがあります');
                    $err = 1;
                }
                else{
                    if ($ary['s11'] > $ary['s12']){
                        $this->validation->custom_error('棚卸年月日の範囲に誤りがあります');
                        $err = 1;
                    }
                }
            }
        if ($ary['c8'] == 'y'){
            if (!$this->validation->required($ary['s13']) && !$this->validation->required($ary['s14'])){
                $this->validation->custom_error('入力年月日を指定してください');
                $err = 1;
            }
            else{
                if (!$this->validation->hiduke($ary['s13']) || !$this->validation->hiduke($ary['s14'])){
                    $this->validation->custom_error('入力年月日の形式に誤りがあります');
                    $err = 1;
                }
                else{
                    if ($ary['s13'] > $ary['s14']){
                        $this->validation->custom_error('入力年月日の範囲に誤りがあります');
                        $err = 1;
                    }
                }
            }

        }
        return $err;
     }
    /*---------------------------------------------------------*
     * SQL
     * @select
     *
     *--------------------------------------------------------*/
     function sql_select ()
     {
        $this->db->select('d0601.denno as denno');
        $this->db->select('d0601.denku_id as denku_id');
        $this->db->select('d0601.grp_id as grp_id');
        $this->db->select('d0601.plant_id as plant_id');
        $this->db->select('d0601.ido_ymd as ido_ymd');
        $this->db->select('d0601.from_id as from_id');
        $this->db->select('d0601.ido_ymd as ido_ymd');
        $this->db->select('d0601.ins_ymd as ins_ymd');
        $this->db->select('d0601.ins_time as ins_time');
        $this->db->select('d0601.horyu_kbn as horyu_kbn');
     }
    /*---------------------------------------------------------*
     * SQL
     * @from join
     *
     *--------------------------------------------------------*/
     function sql_from_join ()
     {
        $this->db->from('d0601');
     }
    /*---------------------------------------------------------*
     * SQL
     * @where
     *
     *--------------------------------------------------------*/
     function sql_where ($ary)
     {

        $this->db->where('d0601.ins_syozoku', $this->session->userdata("m0003_syozoku_id"));
        $this->db->where('d0601.syori_kbn', "5");

        if (!empty($ary['s1'])){
            $this->db->where('d0601.grp_id', $ary['s1']);
        }
        if (!empty($ary['s2'])){
            $this->db->where('d0601.plant_id', $ary['s2']);
        }

        //検索区分
        if (!empty($ary['s3'])){
            if ($ary['s3'] == 3){
                $this->db->where('d0601.denpyo_ymd', '');
            }
            elseif($ary['s3'] == 4){
                $this->db->where('d0601.denpyo_ymd<>', '');
            }
            elseif($ary['s3'] == 2){
                $this->db->where('d0601.horyu_kbn', '1');
            }
        }
        if (!empty($ary['s4'])){
            $this->db->where('d0601.denku_id', $ary['s4']);
        }

        if (!empty($ary['s5'])){
            $this->db->where('d0601.from_id', $ary['s5']);
        }

        if ($ary['c6'] == 'y' && !empty($ary['s10'])){
            $this->db->where('d0601.denno', $ary['s10']);
        }

            if (!empty($ary['s11'])){
                $this->db->where('d0601.ido_ymd>=', ymd_del_c($ary['s11']));
            }
            if (!empty($ary['s12'])){
                $this->db->where('d0601.ido_ymd<=', ymd_del_c($ary['s12']));
            }

        if ($ary['c8'] == 'y' &&  (!empty($ary['s13']) || !empty($ary['s14']))){
            if (!empty($ary['s13'])){
                $this->db->where('d0601.ins_ymd>=', ymd_del_c($ary['s13']));
            }
            if (!empty($ary['s14'])){
                $this->db->where('d0601.ins_ymd<=', ymd_del_c($ary['s14']));
            }
        }


     }

    /*---------------------------------------------------------*
     * SQL
     * @組み立て
     *
     *--------------------------------------------------------*/
     function find ($ary, $per_page, $page_offset)
     {
        $this->sql_select();

        //cache start
        $this->db->start_cache();

        $this->sql_from_join();

        $this->sql_where($ary);

        //cache stop
        $this->db->stop_cache();

        $this->db->order_by('denno asc');

        if ($page_offset != null){
            $page_offset = (int)$page_offset;
        }
        $this->db->limit($per_page, $page_offset);

        $query = $this->db->get();

        //全件数 cache使用
        $total = $this->db->count_all_results();

        $this->db->flush_cache();

        return array($query, $total);
     }

     function set_pagenation ($url, $total, $per_page, $page_offset)
     {
        return array(
            "base_url" => $url. '/',
            "total_rows" => $total,
            "page_offset" => $page_offset,
            "per_page" => $per_page,
            "page_prev" => '',
            "page_next" => '',
            "full_tag_open" => '',
            "full_tag_close" => '',
            "first_link" => '<img src="'. base_url(). 'images/popup/control_first.gif" width="16" height="16" />',
            "first_tag_open" => '<li class="first">',
            "first_tag_close" => '</li>',
            "last_link" => '<img src="'. base_url(). 'images/popup/control_last.gif" width="16" height="16" />',
            "last_tag_open" => '<li class="last">',
            "last_tag_close" => '</li>',
            "next_link" => '<img src="'. base_url(). 'images/popup/control_next.gif" width="16" height="16" />',
            "next_tag_open" => '<li class="next">',
            "next_tag_close" => '</li>',
            "prev_link" => '<img src="'. base_url(). 'images/popup/control_back.gif" width="16" height="16" />',
            "prev_tag_open" => '<li class="prev">',
            "prev_tag_close" => '</li>',
            "cur_tag_open" => '<strong> ',
            "cur_tag_close" => '</strong>',
            "num_tag_open" => '<li>',
            "num_tag_close" => '</li>',
            "num_full_tag_open" => '<li class="numbers"><ol start="1">',
            "num_full_tag_close" => '</ol></li>',
            "a_tag_push" => ''
         );
     }
    /*---------------------------------------------------------*
     * 和暦
     *
     *
     *--------------------------------------------------------*/
        function to_wareki($ymd = '')
        {
            if ($ymd == ""){
                $ymd = date("Ymd");
            }
            $y = substr($ymd, 0, 4);
            $m = substr($ymd, 4, 2);
            $d = substr($ymd, 6, 2);
            //年月日を文字列として結合
            $ymd = sprintf("%02d%02d%02d", $y, $m, $d);
            if ($ymd <= "19120729") {
                $gg = "明治";
                $yy = $y - 1867;
            } elseif ($ymd >= "19120730" && $ymd <= "19261224") {
                $gg = "大正";
                $yy = $y - 1911;
            } elseif ($ymd >= "19261225" && $ymd <= "19890107") {
                $gg = "昭和";
                $yy = $y - 1925;
            } elseif ($ymd >= "19890108" && $ymd <= "20190499") {
              $gg = "平成";
              $yy = $y - 1988;
            } elseif ($ymd >= "20190501") {
              $gg = "令和";
              $yy = $y - 2018;
            }
            $wareki = "{$gg} {$yy} 年 {$m} 月 {$d} 日";
            return $wareki;
        }


     function write_fnc($str, $x, $y, $height)
     {
        $this->pdf->SetXY($x,$y);
        $this->pdf->Write($height,u8_sj($str));
     }
     function add_page($d0601_data, $d0601_list, $m0005_ary = array(), $title = 1)
     {
       if ($d0601_data['horyu_kbn'] == "1"){
            $horyu_kbn = ' *';
        }
        else{
            $horyu_kbn = '';
        }

        /*---------------------------------------------------------*
         * 在庫表タイトル
         *--------------------------------------------------------*/
        $this->pdf->SetXY(67.38, 26.69);
        $title = '実棚卸入力チェックリスト';
        $this->pdf->SetTitle($title);
        $this->pdf->SetFont(GOTHIC,'',18);
        $this->pdf->SetLineWidth(0.5);
        $this->pdf->Cell(76.2, 6.32, u8_sj($title), 'B', 0, 'C');
        /*---------------------------------------------------------*
         * 作成日
         *--------------------------------------------------------*/
        $this->pdf->SetXY(145.34, 22.36);
        $this->pdf->SetFont(GOTHIC,'',10);
        $Ymd = date("Y.m.d(H:i:s)");
        $this->pdf->Cell(51.15, 3.51, u8_sj("作成日：".$Ymd), 0, 0, 'R');
        /*---------------------------------------------------------*
         * ページ番号
         *--------------------------------------------------------*/
        $this->pdf->SetXY(145.34, 26.36);
        $this->pdf->Cell(51.15, 3.51, u8_sj('('. $d0601_data['count_str_pdf']. ')'), 0, 0, 'R');

        /*---------------------------------------------------------*
         * 伝票番号
         *--------------------------------------------------------*/
        $this->pdf->SetXY(164.74, 31.04);
        $this->pdf->SetFont(GOTHIC,'',9);
        $this->pdf->Cell(31.75, 3.16, u8_sj("伝票番号：".$d0601_data['denno']), 0, 0, 'R');
        /*---------------------------------------------------------*
         * ヘッダ情報
         *--------------------------------------------------------*/
        $this->pdf->SetXY(14.11, 37.04);
        $this->pdf->SetFont(GOTHIC,'',10);
        $this->pdf->Cell(162.27, 3.53, u8_sj("棚卸年月日：　".$this->to_wareki($d0601_data['ido_ymd'])), 0, 2, 'L');
        $this->pdf->Cell(162.27, 3.53, u8_sj("グループ　：　".$d0601_data['grp']['name1']. $d0601_data['grp']['name2']), 0, 2, 'L');
        $this->pdf->Cell(162.27, 3.53, u8_sj("プラント　：　".$d0601_data['plant']['name1']. $d0601_data['plant']['name2']), 0, 2, 'L');
        $this->pdf->Cell(162.27, 3.53, u8_sj("在庫場所　：　".$d0601_data['from']['mei1']. $d0601_data['from']['mei2']), 0, 2, 'L');
        /*---------------------------------------------------------*
         * 品目コード　品目　出荷数　備考
         *--------------------------------------------------------*/
        $this->pdf->SetXY(14.11, 56.44);
        $this->pdf->SetLineWidth(0.5);
        $this->pdf->Cell(182.53, 218.55,'', 1, 0);
        $this->pdf->SetFont(GOTHIC,'',9);
        $this->pdf->SetXY(14.11, 56.44);
        $this->pdf->Cell(38.79, 7.05, u8_sj('資材名'), 1, 0, 'C');
        $this->pdf->Cell(80.43, 3.52, u8_sj('品目名'), 1, 2, 'C');
        $this->pdf->Cell(80.43, 3.52, u8_sj('規格'), 1, 0, 'C');
        $this->pdf->SetXY($this->pdf->GetX(),$this->pdf->GetY() - 3.52);
        $this->pdf->Cell(21.16, 7.05, u8_sj('現在在庫数'), 1, 0, 'C');
        $this->pdf->Cell(21.16, 7.05, u8_sj('実棚卸数'), 1, 0, 'C');
        $this->pdf->Cell(21.16, 7.05, u8_sj('差異数'), 1, 1, 'C');
        $this->pdf->SetLineWidth(0.2);

        for($c = 0;$c < 30;$c++){
               $sizai = (isset($d0601_list[$c]['kyotsu_mei'])) ? $d0601_list[$c]['kyotsu_mei']:'';
                $mei = (isset($d0601_list[$c]['mei'])) ? $d0601_list[$c]['mei']: '';
                $kikaku = (isset($d0601_list[$c]['kikaku'])) ? $d0601_list[$c]['kikaku']: '';
                $genzai = (isset($d0601_list[$c]['zaiko_info']['genzai'])) ? $d0601_list[$c]['zaiko_info']['genzai']: '';
                $sai_su = (isset($d0601_list[$c]['ido_su'])) ? nf($d0601_list[$c]['ido_su']): '';
                $tanaorosi = (isset($d0601_list[$c]['yobi_3'])) ? nf($d0601_list[$c]['yobi_3']): '';
                $tani = (isset($d0601_list[$c]['tani'])) ? $d0601_list[$c]['tani']: '';


                $this->pdf->SetXY(14.11, $this->pdf->GetY());
                $this->pdf->SetFont(GOTHIC,'',6);
                $this->pdf->Cell(38.79, 7.05, u8_sj($sizai), 1, 0, 'L');
                $this->pdf->SetFont(GOTHIC,'',9);
                $this->pdf->SetFont(GOTHIC,'',6);
                $this->pdf->Cell(80.43, 3.52, u8_sj($mei), 1, 2, 'L');
                $this->pdf->Cell(80.43, 3.52, u8_sj($kikaku), 1, 0, 'L');
                $this->pdf->SetXY($this->pdf->GetX(),$this->pdf->GetY() - 3.52);
                $this->pdf->SetFont(GOTHIC,'',9);
                $this->pdf->Cell(21.16, 7.05, u8_sj($genzai), 1, 0, 'R');
                $this->pdf->Cell(21.16, 7.05, u8_sj($tanaorosi), 1, 0, 'R');
                $this->pdf->Cell(21.16, 7.05, u8_sj($sai_su), 1, 1, 'R');

            }
     }

    /*---------------------------------------------------------*
     * PDF 送り状発行
     *
     *--------------------------------------------------------*/
     function okuri_hakkou_pdf($d0601_ary, $m0005_ary)
     {
        require(APPPATH.'fpdf/mbfpdf.php');
        define('FPDF_FONTPATH', 'fpdf/font/');
        $this->pdf = new MBFPDF('P', 'mm', 'A4');
        $this->pdf->SetMargins(14.11, 21.16, 13.36);
        $this->pdf->AddMBFont(GOTHIC ,'SJIS');
        $this->pdf->SetAutoPageBreak(false, 20.0);

        $hakkou = array();

        if ($this->input->post('sel') == "y"){
            $hakkou[] = "1";
        }


        if (count($hakkou) <= 0){
            exit;
        }

        foreach($hakkou as $hval){

            foreach ($d0601_ary as $key => $val){

                $val['d0601_data']['count_str'] = $val['d0602_list_total'];
                foreach ($val['d0602_list'] as $val2){

                    if ($hval == 1){
                        $this->pdf->AddPage();
                        $val['d0601_data']['count_str_pdf'] = $val2['count']. '/'. $val['d0601_data']['count_str'];
                        $this->add_page($val['d0601_data'], $val2['list'], $m0005_ary, $hval);
                    }
                }

            }
        }

        /*
        $this->pdf->AddPage();
        $this->pdf->SetFont(GOTHIC,'',7);
        $this->pdf->Write(10,u8_sj('サンプル文字列2'));
        */
        $this->pdf->Output('nouhinsyo.pdf', 'I');
     }

     /*---------------------------------------------------------*
     * SQL
     * 品目の取得
     * d0201
     * 引数:denno
     *
     *--------------------------------------------------------*/
    function get_d0201 ($denno)
    {
        $ary = array();
        $this->db->where(array("denno" => $denno));
        $this->db->limit(1);
        $query = $this->db->get('d0201');
        if ( $query->num_rows() > 0 ){
            return $query->row_array();
        }
        else{
            return false;
        }
    }

     /*---------------------------------------------------------*
     * SQL
     * 品目の取得
     * d0202
     * 引数:seq
     *
     *--------------------------------------------------------*/
    function get_d0202 ($seq)
    {
        $ary = array();
        $this->db->where(array("seq" => $seq));
        $this->db->limit(1);
        $query = $this->db->get('d0202');
        if ( $query->num_rows() > 0 ){
            return $query->row_array();
        }
        else{
            return false;
        }
    }

     /*---------------------------------------------------------*
     * SQL
     * 品目の取得
     * d0202
     * 引数:seq
     *
     *--------------------------------------------------------*/
    function get_d0602_pdf_list ($denno)
    {
        $ary = array();
        $this->db->select('m0004.mei as mei, m0004.kikaku as kikaku');
        $this->db->select('m0004.kyotsu_mei as kyotsu_mei, m0004.syumoku as syumoku');
        $this->db->select('d0602.biko as biko, m0004.tani as tani');
        $this->db->select('m0004.cd as cd');
        $this->db->select('d0602.ido_su as ido_su');
        //$this->db->select('d0602.yobi_3 as yobi_3');//=====(2010.12.13 OSG)=====⇒CUT(yobi_3のvarchar型変更に対応)
        $this->db->select('cast(d0602.yobi_3 as numeric(8,2)) as yobi_3', false);//=====(2010.12.13 OSG)=====⇒ADD(yobi_3のvarchar型変更に対応)
        $this->db->select('d0602.hin_id as hin_id');
        $this->db->from('d0602');
        $this->db->join('m0004', 'd0602.hin_id=m0004.id', 'inner');
        $this->db->where(array("d0602.denno" => $denno));
        $query = $this->db->get();
        if ($query->num_rows() > 0)
        {
            foreach ($query->result_array() as $row)
            {
                $ary[] = $row;
            }
            return $ary;
        }
        return false;
    }

     /*---------------------------------------------------------*
     * SQL
     * 取引先マスタ
     *
     *--------------------------------------------------------*/
    function get_m0005_pdf ()
    {
        $ary = array();
        $this->db->where(array("id" => $this->session->userdata('m0003_syozoku_id')));
        $this->db->limit(1);
        $query = $this->db->get('m0005');
        if ( $query->num_rows() > 0 ){
            return $query->row_array();
        }
        else{
            return false;
        }
    }

     /*---------------------------------------------------------*
     * SQL
     * 品目の取得
     * d0203
     * 引数:denno
     *
     *--------------------------------------------------------*/
    function get_d0203 ($denno)
    {
        $ary = array();

        $this->db->select('d0202.seq as seq');
        $this->db->select('d0202.hin_id as hin_id');
        $this->db->select('m0004.mei as hinmoku1');
        $this->db->select('d0202.syuka_su as syuka_su');
        $this->db->select('d0202.zan_su as zan_su');
        $this->db->select('d0202.biko as biko');
        $this->db->select('d0203.syuka_id as syuka_id');
        $this->db->select('d0203.syuka_denno as syuka_denno');
        $this->db->select('d0203.syuka_seq as syuka_seq');
        $this->db->select('d0203.syuka_su as syuka_su');
        $this->db->select('d0203.cyosei_su as cyosei_su');
        $this->db->select('d0102.user_id as user_id');


        $this->db->from('d0203');
        $this->db->join('d0202', 'd0203.seq=d0202.seq', 'inner');
        $this->db->join('m0004', 'd0202.hin_id=m0004.id', 'inner');
        $this->db->join('d0102', 'd0203.syuka_seq=d0102.seq', 'inner');
        $this->db->where(array("d0203.denno" => $denno));
        $this->db->order_by('d0203.seq desc');
        $query = $this->db->get_where('d0203');
        if ($query->num_rows() > 0)
        {
            foreach ($query->result_array() as $row)
            {
                $ary[] = $row;
            }
            return $ary;
        }
        return false;
    }
    /*---------------------------------------------------------*
     * EXCEL
     *
     *--------------------------------------------------------*/
     function excel($list)
     {

        $csv_ary = array();
        $csv = '';
        //取得エクセルファイル名作成：日付_
        $csv_file_name = date("Y年m月d日"). '棚卸データ'. ".csv";
        $csv_file_name = csv_escape($csv_file_name);

        //セルの値を設定
        $csv_ary[] = csv_escape('選別所名');
        $csv_ary[] = csv_escape('伝票No.');
        $csv_ary[] = csv_escape('保留');
        $csv_ary[] = csv_escape('処理区分名');
        $csv_ary[] = csv_escape('伝票区分名');
        $csv_ary[] = csv_escape('グループ名');
        $csv_ary[] = csv_escape('プラント名');
        $csv_ary[] = csv_escape('移動年月日');
        $csv_ary[] = csv_escape('From移動元CD');
        $csv_ary[] = csv_escape('From移動元名');
        $csv_ary[] = csv_escape('発注No');
        $csv_ary[] = csv_escape('相手伝票No');
        $csv_ary[] = csv_escape('センター連携日');
        $csv_ary[] = csv_escape('センター連携時刻');
        $csv_ary[] = csv_escape('SAP連携日');
        $csv_ary[] = csv_escape('SAP連携時刻');
        $csv_ary[] = csv_escape('SAP連携No.');
        $csv_ary[] = csv_escape('伝票発行日');
        $csv_ary[] = csv_escape('伝票発行時刻');
        $csv_ary[] = csv_escape('受払SEQ');
        $csv_ary[] = csv_escape('品目CD');
        $csv_ary[] = csv_escape('品目名');
        $csv_ary[] = csv_escape('移動数');
        $csv_ary[] = csv_escape('備考');
        $csv_ary[] = csv_escape('発注No.');
        $csv_ary[] = csv_escape('仕入先ID(受託品)');
        $csv_ary[] = csv_escape('仕入先名(受託品)');
        $csv_ary[] = csv_escape('登録利用者ID');
        $csv_ary[] = csv_escape('登録所属会社ID');
        $csv_ary[] = csv_escape('登録日付');
        $csv_ary[] = csv_escape('登録時間');
        $csv_ary[] = csv_escape('登録プログラムID');
        $csv_ary[] = csv_escape('更新利用者ID');
        $csv_ary[] = csv_escape('更新所属会社ID');
        $csv_ary[] = csv_escape('更新日付');
        $csv_ary[] = csv_escape('更新時間');
        $csv_ary[] = csv_escape('更新プログラムID');

        $ary[] = implode(",", $csv_ary);

        foreach ($list as $row){
            $query02 = '';

            $row01 = array();
            $row02 = array();

            // 0601
            $row01 = $this->find_one('d0601', array('denno' => $row['denno']));
            // 0602
            $query02 = $this->db->get_where('d0602', array('denno' => $row['denno']));

            //senbetsu_id
            $item_senbetsu = $this->find_one( "m0005", array("id" => $this->session->userdata('m0003_syozoku_id')) ,"mei1");
            //syori kbn
            if ($row01['syori_kbn'] == 1){
                $row01['syori_kbn_name'] = '入荷データ';
            }
            elseif($row01['syori_kbn'] == 2){
                $row01['syori_kbn_name'] = '出荷データ';
            }
            elseif($row01['syori_kbn'] == 3){
                $row01['syori_kbn_name'] = '振替データ';
            }
            elseif($row01['syori_kbn'] == 5){
                $row01['syori_kbn_name'] = '棚卸データ';
            }
            else{
                $row01['syori_kbn_name'] = '選別サマリ';
            }
            //horyu_kbn
            if ($row01['horyu_kbn'] != 2){
                $row01['horyu_kbn_name'] = '保留';
            }
            else{
                $row01['horyu_kbn_name'] = '';
            }

            //from
            $item_from = $this->find_one( "m0005", array("id" => $row01['from_id']) ,"cd, mei1");

            if ($query02->num_rows() > 0){
                foreach ($query02->result_array() as $row02){
                    //品目
                    $item_hin = $this->find_one( "m0004", array("id" => $row02['hin_id']) ,"cd, mei");

                    $csv_ary = array();
                    $csv_ary[] = (isset($item_senbetsu['mei1'])) ? csv_escape($item_senbetsu['mei1']) : '';
                    $csv_ary[] = csv_escape($row01['denno']);
                    $csv_ary[] = csv_escape($row01['horyu_kbn_name']);
                    $csv_ary[] = csv_escape($row01['syori_kbn_name']);
                    $csv_ary[] = csv_escape($row['denku_name']);
                    $csv_ary[] = csv_escape($row['grp_name']);
                    $csv_ary[] = csv_escape($row['plant_name']);
                    $csv_ary[] = csv_escape($row01['ido_ymd']);
                    $csv_ary[] = (isset($item_from['cd'])) ? csv_escape($item_from['cd']) : '';
                    $csv_ary[] = (isset($item_from['mei1'])) ? csv_escape($item_from['mei1']) : '';
                    $csv_ary[] = csv_escape($row01['hacyu_no']);
                    $csv_ary[] = csv_escape($row01['aite_no']);
                    $csv_ary[] = csv_escape($row01['center_ymd']);
                    $csv_ary[] = csv_escape($row01['center_time']);
                    $csv_ary[] = csv_escape($row01['sap_ymd']);
                    $csv_ary[] = csv_escape($row01['sap_time']);
                    $csv_ary[] = csv_escape($row01['sap_no']);
                    $csv_ary[] = csv_escape($row01['denpyo_ymd']);
                    $csv_ary[] = csv_escape($row01['denpyo_time']);
                    $csv_ary[] = csv_escape($row02['seq']);
                    $csv_ary[] = (isset($item_hin['cd'])) ? csv_escape($item_hin['cd']) : '';
                    $csv_ary[] = (isset($item_hin['mei'])) ? csv_escape($item_hin['mei']) : '';
                    $csv_ary[] = csv_escape($row02['ido_su']);
                    $csv_ary[] = csv_escape($row02['biko']);
                    $csv_ary[] = csv_escape($row02['hacyu_no']);

                    $item_siire = $this->find_one( "m0005", array("id" => $row02['siire_id']) ,"cd, mei1");
                    $csv_ary[] = (isset($item_siire['cd'])) ? csv_escape($item_siire['cd']): '';
                    $csv_ary[] = (isset($item_siire['mei1'])) ? csv_escape($item_siire['mei1']): '';
                    $csv_ary[] = csv_escape($row02['ins_riyo_id']);
                    $csv_ary[] = csv_escape($row02['ins_syozoku']);
                    $csv_ary[] = csv_escape($row02['ins_ymd']);
                    $csv_ary[] = csv_escape($row02['ins_time']);
                    $csv_ary[] = csv_escape($row02['ins_pgm_id']);
                    $csv_ary[] = csv_escape($row02['upd_riyo_id']);
                    $csv_ary[] = csv_escape($row02['upd_syozoku']);
                    $csv_ary[] = csv_escape($row02['upd_ymd']);
                    $csv_ary[] = csv_escape($row02['upd_time']);
                    $csv_ary[] = csv_escape($row02['upd_pgm_id']);

                    $ary[] = implode(",", $csv_ary);

                }
            }
            else{
                continue;
            }

        }

        $csv = implode("\n", $ary);

        //出力
        header("Cache-Control: public");
        header("Pragma: public");
        header("Content-type: application/x-msexcel-csv");
        header("Content-Disposition: attachment; filename=".$csv_file_name);
        echo $csv;
     }
/*---------------------------------------------------------*
 * 1件取得
 *
 *--------------------------------------------------------*/
    function find_one( $table = '', $where = '' ,$select = ''){
        $ary = array();
        if ($table == '' || $where == ''){
            return $ary;
        }
        if ($select == null){
            $this->db->select('*');
        }
        else{
            $this->db->select($select);
        }
        $query = $this->db->get_where( $table, $where, 1 );
        if ( $query->num_rows() > 0 ){
            return $query->row_array();
        }
        else{
            return $ary;
        }
    }

    /*---------------------------------------------------------*
     * ストックSPパーツ取得
     * @HTML表示部
     *
     *--------------------------------------------------------*/
     function get_m0005($id)
     {
        //stockp
        $this->db->select('m0005.mei1 as mei1');
        if ($id == ""){
            return '';
        }
        else{
            $query = $this->db->get_where( "m0005", array("id" => $id), 1 );
            if ( $query->num_rows() > 0 ){
                $ary = $query->row_array();
                return $ary['mei1'];
            }
            else{
                return '';
            }
        }
     }
    /*---------------------------------------------------------*
     * グループパーツ取得
     * @HTML表示部
     *
     *--------------------------------------------------------*/
     function get_m0002($id)
     {
        if ($id == ""){
            return '';
        }
        else{
            $this->db->select('m0002.name1 as name1');
            $query = $this->db->get_where( "m0002", array("id" => $id), 1 );
            if ( $query->num_rows() > 0 ){
                $ary = $query->row_array();
                return  $ary['name1'];
            }
            else{
                return '';
            }
        }
     }

    /*-----------------------------------------------------/
     * grp_idでセレクトボックス作成
     * ajax 送り先
    /-----------------------------------------------------*/
    function get_grp_selectbox ($ary = array(), $selected = 0){
        $str = '';
        if (count($ary) <= 0){
            return;
        }
        else{
            foreach ($ary as $val){
                if ($selected == $val['id']){
                    $selected_str = ' selected="selected"';
                }
                else{
                    $selected_str = '';
                }
                $str .= '<option value="'. $val['id']. '"'. $selected_str. '>'. $val['mei1']. '</option>'. "\n";
            }
            return $str;
        }
    }
/*-----------------------------------------------------/
 * select box
 *
 *
 *
 *
/-----------------------------------------------------*/

    /*-----------------------------------------------------/
     * group select
    /-----------------------------------------------------*/
    function get_group ($group_id = '')
    {
        $ary = array();
        $row = array();
        $this->db->select('m0002.id, m0002.name1, m0002.name2');
        $this->db->from('m0204');
        $this->db->join('m0002', 'm0204.value = m0002.id', 'inner');
        $this->db->where(array("m0204.ctrl_kbn" => 's2'));
        $this->db->where(array("m0204.ctrl_kmk1" => $this->session->userdata('m0003_id')));
        $this->db->where(array("m0204.ctrl_kmk2" => '999'));
        $this->db->where(array("m0204.ctrl_kmk3" => '999'));
        $this->db->order_by('m0002.cd asc');
        $query = $this->db->get();
        if ($query->num_rows() > 0){
            foreach ($query->result_array() as $row){
                $ary[] = $row;
            }
        }
        unset($row);
        return $ary;
    }

    /*-----------------------------------------------------/
     * plant select
    /-----------------------------------------------------*/
    function get_plant ($group_id = '')
    {
        $ary = array();
        $row = array();

        if ($group_id == ''){
            return array();
        }

        $this->db->select('m0002.id, m0002.name1, m0002.name2');
        $this->db->from('m0204');
        $this->db->join('m0002', 'm0204.value = m0002.id', 'inner');
        $this->db->where(array("m0204.ctrl_kbn" => "sh2"));
        $this->db->where(array("m0204.ctrl_kmk1" => $group_id));
        $this->db->where(array("m0204.ctrl_kmk2" => $this->session->userdata('m0003_id')));
        $this->db->where(array("m0204.ctrl_kmk3" => '999'));
        $this->db->order_by('m0002.cd asc');
        $query = $this->db->get();
        if ($query->num_rows() > 0){
            foreach ($query->result_array() as $row){
                $ary[] = $row;
            }
        }
        unset($row);
        return $ary;
    }

    /*-----------------------------------------------------/
     * denku select
    /-----------------------------------------------------*/
    function get_denku ()
    {
        $ary = array();
        $row = array();
        $this->db->select('m0002.id, m0002.name1, m0002.name2');
        $this->db->from('m0204');
        $this->db->join('m0002', 'm0204.value = m0002.id', 'inner');
        $this->db->where(array("m0204.ctrl_kbn" => "s1"));
        $this->db->where(array("m0204.ctrl_kmk1" => $this->session->userdata('m0003_id')));
        $this->db->where(array("m0204.ctrl_kmk2" => 'lmr02220'));
        $this->db->where(array("m0204.ctrl_kmk3" => '999'));
        $this->db->order_by('m0002.cd asc');
        $query = $this->db->get();
        if ($query->num_rows() > 0){
            foreach ($query->result_array() as $row){
                $ary[] = $row;
            }
        }
        unset($row);
        return $ary;
    }

    /*-----------------------------------------------------/
     * from select
    /-----------------------------------------------------*/
    function get_from ($group_id = '')
    {

        $ary = array();
        $row = array();

        if ($group_id == ''){
            return array();
        }

        $this->db->select('m0005.id, m0005.mei1, m0005.mei2, m0005.ini');
        $this->db->from('m0204');
        $this->db->join('m0005', 'm0204.value = m0005.id', 'inner');
        $this->db->where("m0204.ctrl_kbn", "s3");
        $this->db->where("m0204.ctrl_kmk1", $group_id);
        $this->db->where("m0204.ctrl_kmk2", $this->session->userdata('m0003_id'));
        $this->db->where("m0204.ctrl_kmk3", '999');
        $this->db->order_by('m0005.cd asc');
        $query = $this->db->get();
        if ($query->num_rows() > 0){
            foreach ($query->result_array() as $row){
                $ary[] = $row;
            }
        }

        unset($row);
        return $ary;
    }

/*-----------------------------------------------------/
 * ajax
 *
 *
 *
 *
 *
 *
 *
 *
/-----------------------------------------------------*/

    /*-----------------------------------------------------/
     * group
    /-----------------------------------------------------*/
    function get_group_html ($selected = 0)
    {
        if ($selected == 0 || $selected == ''){
            $str = '<option value="" selected="selected">選択してください</option>';
        }
        else{
            $str = '<option value="">選択してください</option>';
        }
        $ary = array();

        $ary = $this->get_group();
        foreach ($ary as $val){
            if ($selected == $val['id']){
                $selected_str = ' selected="selected"';
            }
            else{
                $selected_str = '';
            }

            $str .= '<option value="'. $val['id']. '"'. $selected_str. '>'. $val['name1']. "　". $val['name2']. '</option>'. "\n";
        }
        return $str;
    }
    /*-----------------------------------------------------/
     * plant
     * ajax
    /-----------------------------------------------------*/
    function get_plant_html ($group_id = '', $selected = 0){
        if ($selected == 0 || $selected == ''){
            $str = '<option value="" selected="selected">選択してください</option>';
        }
        else{
            $str = '<option value="">選択してください</option>';
        }
        $ary = array();
        if ($group_id == ''){
            return $str;
        }
        $ary = $this->get_plant($group_id);
        foreach ($ary as $val){
            if ($selected == $val['id']){
                $selected_str = ' selected="selected"';
            }
            else{
                $selected_str = '';
            }

            $str .= '<option value="'. $val['id']. '"'. $selected_str. '>'. $val['name1']. $val['name2']. '</option>'. "\n";

        }
        return $str;
    }

    /*-----------------------------------------------------/
     * denku select
    /-----------------------------------------------------*/
    function get_denku_html ($selected = 0)
    {
        if ($selected == 0 || $selected == ''){
            $str = '<option value="" selected="selected">すべて対象にする</option>';
        }
        else{
            $str = '<option value="">すべて対象にする</option>';
        }
        $ary = array();

        $ary = $this->get_denku();
        foreach ($ary as $val){
            if ($selected == $val['id']){
                $selected_str = ' selected="selected"';
            }
            else{
                $selected_str = '';
            }

            $str .= '<option value="'. $val['id']. '"'. $selected_str. '>'. $val['name1']. $val['name2']. '</option>'. "\n";
        }
        return $str;
    }

    /*-----------------------------------------------------/
     * from
     * ajax
    /-----------------------------------------------------*/
  function get_from_html ($group_id = '', $selected = ''){
        if ($selected == 0 || $selected == ''){
            $str = '<option value="" selected="selected">選択してください</option>';
        }
        else{
            $str = '<option value="">選択してください</option>';
        }
        $ary = array();
        if ($group_id == ''){
            return $str;
        }

        $ary = $this->get_from($group_id);

        foreach ($ary as $val){
            if ($selected == $val['id']){
                $selected_str = ' selected="selected"';
            }
            else{
                $selected_str = '';
            }
            $str .= '<option value="'. $val['id']. '"'. $selected_str. '>'. $val['ini']. '</option>'. "\n";
        }
        return $str;
    }


}
?>