<?php

class Session_model extends Model {

  function __construct()
  {
    parent::Model();
  }

/*---------------------------------------------------------*
 * ワークテーブルゴミデータ削除
 *
 *--------------------------------------------------------*/
    function table_day_delete ($table = null)
    {
        if ($table == null){
            return false;
        }
        $this->db->where("ins_ymd||ins_time<to_char(now() - interval '2 days', 'yyyymmddhh24miss')", NULL, FALSE);
        $this->db->delete($table);

    }
    function m0003_kyoka ()
    {
        // ログイン後、再度許可フラグを取得
        $this->db->select('id');
        $this->db->where(array("id" => $this->session->userdata('m0003_id'), "kyoka" => "1"));
        if ($this->db->count_all_results("m0003")){
            return true;
        }
        else{
            //session 破棄
            $this->session->sess_destroy();
            return false;
        }

    }
    function timeout_delete ()
    {
        //６０分以上経過しているセッションを削除
        $ary = array();
        $this->db->select('id');
       $this->db->where("access_ymd||access_time<to_char(now() - interval '40 minutes', 'yyyymmddhh24miss')", NULL, FALSE);

        $query = $this->db->get('m0010');

        if ($query->num_rows() > 0){
            foreach ($query->result_array() as $val)
            {
                $ary[] = $val['id'];
            }
            $tables = array('m0010', 'm0011', 'm0015');
            $this->db->where_in("id", $ary);
            $this->db->delete($tables);

            $tables = array('t0101', 'e0101', 't0102', 'e0102', 'e0201', 'e0202', 'e0203', 't0201', 't0202', 't0203');
            $this->db->where_in("m0010_id", $ary);
            $this->db->delete($tables);

            $tables = array('t0301', 't0302', 'e0301', 'e0302');
            $this->db->where_in("m0010_id", $ary);
            $this->db->delete($tables);

            $tables = array('e0501', 'e0502', 'e0503', 'e0504', 'e0505');
            $this->db->where_in("m0010_id", $ary);
            $this->db->delete($tables);

            $tables = array('t0601', 't0602', 'e0601', 'e0602');
            $this->db->where_in("m0010_id", $ary);
            $this->db->delete($tables);

        }

        //伝票ロックテーブル削除  2時間
        $this->session_model->m0015_hours_delete ();

        //２日前のデータ削除
        $tables = array('m0010', 'm0011');
        $this->session_model->table_day_delete($tables);
        $tables = array('t0101', 'e0101', 't0102', 'e0102', 'e0201', 'e0202', 'e0203', 't0201', 't0202', 't0203');
        $this->session_model->table_day_delete($tables);
        $tables = array('t0601', 't0602', 'e0601', 'e0602');
        $this->session_model->table_day_delete($tables);
        $tables = array('t0301', 't0302', 'e0301', 'e0302');
        $this->session_model->table_day_delete($tables);
        $tables = array('e0501', 'e0502', 'e0503', 'e0504', 'e0505');
        $this->session_model->table_day_delete($tables);
    }
/*---------------------------------------------------------*
 * サイトログインセッション
 *
 *--------------------------------------------------------*/
    function m0010_session($pgm_id = "", $param = null)
    {

        $this->timeout_delete();

        //メンバーズセッションが空の場合は作成。同一IDならはじく。
        if (!$this->session->userdata('m0010_id')){
            if ($this->common_db_model->getcount ("m0010", "id", array("riyo_id" => $this->session->userdata('m0003_id')))){
                if ($param == null){
                    //show_error("重複ログイン<br />同じアカウントでログインしています。"); //=====(2012.05.28 OSG)=====⇒CUT(強制ログアウトボタンを追加)
                    //依存ファイル(controllers/lmr00010.php[207行目付近] forced_logged_out関数)30秒の設定を記述している
                    show_error('重複ログイン' //=====(2012.05.28 OSG)=====⇒ADD(強制ログアウトボタンを追加)
                        .'<br />'.'同じアカウントでログインしています。'
                        .'<br />'.'30秒以上アクセスの無いユーザーは強制的にログアウトが可能です。本当に操作中で無いことをご確認の上、実行ください。'
                        .'<br />'.'<a href="'.site_url()."lmr00010/forced_logged_out".'">強制ログアウト</a>'
                    );
                }
                else{
                    echo '<script type="text/javascript">self.parent.tb_remove();</script>';exit;
                }
            }
            else{
                    $random_Str = $this->_random();

                    $this->db->set('id', $random_Str );
                    $this->db->set('access_ymd',"to_char(now(),'yyyymmdd')", FALSE );
                    $this->db->set('access_time', "to_char(now(),'hh24miss')", FALSE );
                    $this->db->set('riyo_id', $this->session->userdata('m0003_id') );
                    $this->db->set('ins_riyo_id', $this->session->userdata('m0003_id'));
                    $this->db->set('ins_syozoku', $this->session->userdata('m0003_syozoku_id'));
                    $this->db->set('ins_pgm_id', $pgm_id);
                    $this->db->set('ins_ymd', "to_char(now(),'yyyymmdd')", FALSE);
                    $this->db->set('ins_time', "to_char(now(),'hh24miss')", FALSE);

                    if ($this->common_db_model->insert("m0010")){
                        $this->session->set_userdata(array('m0010_id' => $random_Str));
                        if ($this->m0003_kyoka ()){
                            return true;
                        }
                        else{
                            $this->db->where("riyo_id", $this->session->userdata('m0003_id'));
                            $this->db->delete('m0010');
                            show_error("このログインアカウントは現在ご利用を許可しておりません");
                        }

                    }
                    else{
                        show_error("セッションを作成できませんでした");
                    }
            }
        }

        //メンバーズセッションが存在する場合は照合して正しければアップデート
        else{
            //テーブルに該当セッションなし
            if (!$this->common_db_model->getcount ("m0010", "id", array("id" => $this->session->userdata('m0010_id')))){
                if ($param == null){
                    redirect("lmr00010/logged_out");
                }
                else{
                    echo '<script type="text/javascript">self.parent.tb_remove();</script>';exit;
                }
            }
            else{
                $this->db->set('access_ymd', "to_char(now(),'yyyymmdd')", FALSE);
                $this->db->set('access_time', "to_char(now(),'hh24miss')", FALSE);
                $this->db->set('upd_riyo_id', $this->session->userdata('m0003_id'));
                $this->db->set('upd_syozoku', $this->session->userdata('m0003_syozoku_id'));
                $this->db->set('upd_pgm_id', $pgm_id);
                $this->db->set('upd_ymd', "to_char(now(),'yyyymmdd')", FALSE);
                $this->db->set('upd_time', "to_char(now(),'hh24miss')", FALSE);
                $this->db->where(array("id" => $this->session->userdata('m0010_id')));

                if ($this->common_db_model->update("m0010")){
                    if ($this->m0003_kyoka ()){
                        return true;
                    }
                    else{
                        $this->db->where("riyo_id", $this->session->userdata('m0003_id'));
                        $this->db->delete('m0010');
                        show_error("このログインアカウントは現在、ご利用を許可しておりません");
                    }
                }
                else{
                    if ($param == null){
                        show_error("セッションを作成できませんでした");
                    }
                    else{
                        echo '<script type="text/javascript">self.parent.tb_remove();</script>';exit;
                    }
                }
            }
        }

    }
/*---------------------------------------------------------*
 * 特定プログラムのアクセスセッションチェック
 *
 *--------------------------------------------------------*/
    function m0011_is_session($pgm_id = null, $param = null)
    {
        if ($pgm_id == null){
            show_error("プログラムIDが不明です");
        }
        if (!$this->session->userdata('m0010_id')){
            show_error("ログインセッションIDが不明です");
        }
        $ary = array(
                "id<>" => $this->session->userdata('m0010_id'),
                "jigyo_id" => $this->session->userdata('m0003_syozoku_id'),
                "pgm_id" => $pgm_id
                );
        //テーブルに同じ会社で同じプログラムID、別のセッションデータがある場合はエラー
        if ($this->common_db_model->getcount("m0011","id", $ary)){

                if ($param == null){
                    show_error("重複アクセス<br />同じ会社の人がアクセスしています");
                }
                else{
                    echo '<script type="text/javascript">self.parent.tb_remove();</script>';exit;
                }
        }
        else{
            $ary = array(
                    "id" => $this->session->userdata('m0010_id'),
                    "jigyo_id" => $this->session->userdata('m0003_syozoku_id'),
                    "pgm_id" => $pgm_id
                    );
            //すでに自分のセッションがあれば更新
            if ($this->common_db_model->getcount("m0011","id", $ary)){

                $this->db->set('pgm_id', $pgm_id);
                $this->db->set('access_ymd', "to_char(now(),'yyyymmdd')", FALSE);
                $this->db->set('access_time', "to_char(now(),'hh24miss')", FALSE);
                $this->db->set('upd_riyo_id', $this->session->userdata('m0003_id'));
                $this->db->set('upd_syozoku', $this->session->userdata('m0003_syozoku_id'));
                $this->db->set('upd_pgm_id', $pgm_id);
                $this->db->set('upd_ymd', "to_char(now(),'yyyymmdd')", FALSE);
                $this->db->set('upd_time', "to_char(now(),'hh24miss')", FALSE);
                $this->db->where(array("id" => $this->session->userdata('m0010_id')));

                if (!$this->common_db_model->update("m0011")){

                    if ($param == null){
                        show_error("セッションを更新できませんでした");
                    }
                    else{
                        echo '<script type="text/javascript">self.parent.tb_remove();</script>';exit;
                    }

                }

            }
            //セッション作成
            else{

                $this->db->set('id', $this->session->userdata('m0010_id'));
                $this->db->set('jigyo_id', $this->session->userdata('m0003_syozoku_id'));
                $this->db->set('pgm_id', $pgm_id);
                $this->db->set('access_ymd',"to_char(now(),'yyyymmdd')", FALSE );
                $this->db->set('access_time', "to_char(now(),'hh24miss')", FALSE );
                $this->db->set('ins_riyo_id', $this->session->userdata('m0003_id'));
                $this->db->set('ins_syozoku', $this->session->userdata('m0003_syozoku_id'));
                $this->db->set('ins_pgm_id', $pgm_id);
                $this->db->set('ins_ymd', "to_char(now(),'yyyymmdd')", FALSE);
                $this->db->set('ins_time', "to_char(now(),'hh24miss')", FALSE);

                if (!$this->common_db_model->insert("m0011")){

                    if ($param == null){
                        show_error("セッションを更新できませんでした");
                    }
                    else{
                        echo '<script type="text/javascript">self.parent.tb_remove();</script>';exit;
                    }
                }
            }
        }
    }
/*---------------------------------------------------------*
 * 伝票ロック
 *
 *--------------------------------------------------------*/
    function m0015_is_session($pgm_id = null, $denno = null, $pgm_lms_no = null)
    {
        if ($pgm_id == null){
            show_error("プログラムIDが不明です");
        }

        if ($denno == null){
            show_error("伝票ＮＯが不明です");
        }

        if (!$this->session->userdata('m0010_id')){
            show_error("ログインセッションIDが不明です");
        }
        $ary = array(
                "id<>" => $this->session->userdata('m0010_id'),
                "pgm_id" => $pgm_id,
                "denno" => $denno
                );
        //テーブルに同じ会社で同じプログラムID、同じ伝票、別のセッションデータがある場合はエラー
        if ($this->common_db_model->getcount("m0015","id", $ary)){
            $this->session->set_flashdata('flash_message', 'この伝票は開くことができません');
            return false;
        }
        else{
            $ary = array(
                    "id" => $this->session->userdata('m0010_id'),
                    "pgm_id" => $pgm_id,
                    "denno" => $denno
                    );
            //すでに自分のセッションがあれば更新
            if ($this->common_db_model->getcount("m0015","id", $ary)){

                $this->db->set('denno', $denno);
                $this->db->set('pgm_id', $pgm_id);
                $this->db->set('access_ymd', "to_char(now(),'yyyymmdd')", FALSE);
                $this->db->set('access_time', "to_char(now(),'hh24miss')", FALSE);
                $this->db->set('upd_riyo_id', $this->session->userdata('m0003_id'));
                $this->db->set('upd_syozoku', $this->session->userdata('m0003_syozoku_id'));
                $this->db->set('upd_pgm_id', $pgm_lms_no);
                $this->db->set('upd_ymd', "to_char(now(),'yyyymmdd')", FALSE);
                $this->db->set('upd_time', "to_char(now(),'hh24miss')", FALSE);
                $this->db->where(array("id" => $this->session->userdata('m0010_id')));

                if (!$this->common_db_model->update("m0015")){
                    //セッションを更新できませんでした
                    $this->session->set_flashdata('flash_message', 'この伝票は開くことができません(セッションを更新できませんでした)');
                    return false;
                }

            }
            //セッション作成
            else{

                $this->db->set('id', $this->session->userdata('m0010_id'));
                $this->db->set('jigyo_id', $this->session->userdata('m0003_syozoku_id'));
                $this->db->set('denno', $denno);
                $this->db->set('pgm_id', $pgm_id);
                $this->db->set('access_ymd',"to_char(now(),'yyyymmdd')", FALSE );
                $this->db->set('access_time', "to_char(now(),'hh24miss')", FALSE );
                $this->db->set('ins_riyo_id', $this->session->userdata('m0003_id'));
                $this->db->set('ins_syozoku', $this->session->userdata('m0003_syozoku_id'));
                $this->db->set('ins_pgm_id', $pgm_lms_no);
                $this->db->set('ins_ymd', "to_char(now(),'yyyymmdd')", FALSE);
                $this->db->set('ins_time', "to_char(now(),'hh24miss')", FALSE);

                if (!$this->common_db_model->insert("m0015")){
                    //セッションを作成できませんでした
                    $this->session->set_flashdata('flash_message', 'この伝票は開くことができません(セッションを作成できませんでした)');
                    return false;
                }
            }
            return true;
        }
    }
/*---------------------------------------------------------*
 * 伝票ロック
 *
 *--------------------------------------------------------*/
    function m0015_getcount($pgm_id = null, $denno = null)
    {
        if ($pgm_id == null){
            show_error("プログラムIDが不明です");
        }

        if ($denno == null){
            show_error("伝票ＮＯが不明です");
        }

        if (!$this->session->userdata('m0010_id')){
            show_error("ログインセッションIDが不明です");
        }
        $ary = array(
                "id<>" => $this->session->userdata('m0010_id'),
                "denno" => $denno
                );
        //テーブルに同じ会社で同じプログラムID、同じ伝票、別のセッションデータがある場合はエラー
        if ($this->common_db_model->getcount("m0015","id", $ary)){
            return false;
        }
        else{
            return true;
        }
    }
/*---------------------------------------------------------*
 * 伝票ロック
 *
 *--------------------------------------------------------*/
    function m0015_delete($pgm_id = null, $denno = null)
    {
/*
        if ($pgm_id == null){
            show_error("プログラムIDが不明です");
        }

        if ($denno == null){
            show_error("伝票ＮＯが不明です");
        }
*/
        if (!$this->session->userdata('m0010_id')){
            show_error("ログインセッションIDが不明です");
        }
        $ary = array(
                "id" => $this->session->userdata('m0010_id')
                );
        $this->common_db_model->delete("m0015", $ary);
    }
/*---------------------------------------------------------*
 * m0015 ワークテーブルゴミデータ削除
 *
 *--------------------------------------------------------*/
    function m0015_hours_delete ()
    {
        $this->db->where("access_ymd||access_time<to_char(now() - interval '120 minutes', 'yyyymmddhh24miss')", NULL, FALSE);
        $this->db->delete('m0015');

    }
/*---------------------------------------------------------*
 * ランダム文字列作成
 *
 *--------------------------------------------------------*/
    function _random()
    {
                $bool = false;
                while ($bool == false){
                    $randam_string = $this->crandom->GetRandomString(10);
                    if (!$this->common_db_model->getcount("m0010", "id", array("id" => $randam_string))){
                        return $randam_string;
                    }
                }
    }
/*---------------------------------------------------------*
 * SAVE チケット処理
 *
 *--------------------------------------------------------*/
    function get_ticket()
    {
        $this->session->set_userdata('save_ticket', $this->crandom->GetRandomString(6).time());
        echo '<input type="hidden" name="save_ticket" value="'. $this->session->userdata('save_ticket'). '">';
    }
    function check_ticket($ticket = null)
    {
        if ($ticket == null){
            return false;
        }
        if ($this->session->userdata('save_ticket') == $ticket){
            return true;
        }
        else{
            return false;
        }
    }
    function call_ticket($ticket = null)
    {
        if ($ticket == null){
            show_error("処理をする権限が与えられていません");
        }
        if (!$this->check_ticket($ticket)){
            show_error("処理をする権限が与えられていません");
        }
    }
}
?>